/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.srv;

import org.n52.io.DatasetFactoryException;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.TimeseriesMetadataOutput;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.io.series.TvpDataCollection;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.n52.series.db.da.TimeseriesRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.srv.DataService;
import org.n52.series.srv.AccessService;
import org.n52.web.exception.InternalServerException;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated
public class TimeseriesAccessService
extends AccessService<TimeseriesMetadataOutput>
implements DataService<Data<QuantityValue>> {
    @Autowired
    private IDataRepositoryFactory factory;

    public TimeseriesAccessService(TimeseriesRepository repository) {
        super(repository);
    }

    public DataCollection<Data<QuantityValue>> getData(IoParameters parameters) {
        try {
            TvpDataCollection dataCollection = new TvpDataCollection();
            for (String timeseriesId : parameters.getDatasets()) {
                Data<QuantityValue> data = this.getDataFor(timeseriesId, parameters);
                if (data == null) continue;
                dataCollection.addNewSeries(timeseriesId, data);
            }
            return dataCollection;
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not get series data from database.", (Throwable)e);
        }
    }

    private Data<QuantityValue> getDataFor(String timeseriesId, IoParameters parameters) throws DataAccessException {
        DbQuery dbQuery = this.dbQueryFactory.createFrom(parameters);
        DataRepository<?, ?> dataRepository = this.createRepository();
        return dataRepository.getData(timeseriesId, dbQuery);
    }

    private DataRepository<?, ?> createRepository() throws DataAccessException {
        try {
            return this.factory.create("quantity");
        }
        catch (DatasetFactoryException e) {
            throw new DataAccessException(e.getMessage());
        }
    }

    public IDataRepositoryFactory getFactory() {
        return this.factory;
    }

    public void setFactory(IDataRepositoryFactory factory) {
        this.factory = factory;
    }
}

