/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.OuterJoinLoadable;

public final class DataModelUtil {
    public static Date createUnmutableTimestamp(Date value) {
        if (value == null) {
            return null;
        }
        return !(value instanceof Timestamp) ? new Timestamp(value.getTime()) : (Date)Timestamp.class.cast(value);
    }

    public static boolean isPropertyNameSupported(String property, Class<?> clazz, Session session) {
        SessionFactoryImplementor factory = DataModelUtil.getSessionFactory(session);
        return DataModelUtil.hasProperty(property, factory.getClassMetadata(clazz));
    }

    public static boolean isPropertyNameSupported(String property, Criteria criteria) {
        SessionFactoryImplementor factory = DataModelUtil.extractSessionFactory(criteria);
        CriteriaImpl criteriaImpl = DataModelUtil.getCriteriaImpl(criteria);
        if (criteriaImpl == null) {
            return false;
        }
        String entityOrClassName = criteriaImpl.getEntityOrClassName();
        ClassMetadata classMetadata = factory.getClassMetadata(entityOrClassName);
        return classMetadata != null && DataModelUtil.hasProperty(property, classMetadata);
    }

    private static boolean hasProperty(String property, ClassMetadata metadata) {
        List<String> properties = Arrays.asList(metadata.getPropertyNames());
        return properties.contains(property);
    }

    public static boolean isNamedQuerySupported(String namedQuery, Session session) {
        SessionFactoryImplementor factory = DataModelUtil.getSessionFactory(session);
        NamedQueryDefinition namedQueryDef = factory.getNamedQuery(namedQuery);
        NamedSQLQueryDefinition namedSQLQueryDef = factory.getNamedSQLQuery(namedQuery);
        return namedQueryDef != null || namedSQLQueryDef != null;
    }

    private static SessionFactoryImplementor getSessionFactory(Session session) {
        return ((SessionImpl)session).getSessionFactory();
    }

    public static String getSqlString(Criteria criteria) {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        SessionImplementor session = criteriaImpl.getSession();
        SessionFactoryImplementor factory = DataModelUtil.extractSessionFactory(criteria);
        CriteriaQueryTranslator translator = new CriteriaQueryTranslator(factory, criteriaImpl, criteriaImpl.getEntityOrClassName(), "this_");
        String[] implementors = factory.getImplementors(criteriaImpl.getEntityOrClassName());
        OuterJoinLoadable joinLoader = (OuterJoinLoadable)factory.getEntityPersister(implementors[0]);
        CriteriaJoinWalker walker = new CriteriaJoinWalker(joinLoader, translator, factory, criteriaImpl, criteriaImpl.getEntityOrClassName(), session.getLoadQueryInfluencers());
        return walker.getSQLString();
    }

    public static boolean isEntitySupported(Class<?> clazz, Criteria criteria) {
        SessionFactoryImplementor factory = DataModelUtil.extractSessionFactory(criteria);
        if (factory != null) {
            return factory.getAllClassMetadata().keySet().contains(clazz.getName());
        }
        return false;
    }

    public static SessionFactoryImplementor extractSessionFactory(Criteria criteria) {
        SessionImplementor session = DataModelUtil.getSessionImplementor(criteria);
        return session != null ? session.getFactory() : null;
    }

    private static SessionImplementor getSessionImplementor(Criteria criteria) {
        SessionImplementor session = null;
        if (criteria instanceof CriteriaImpl) {
            session = ((CriteriaImpl)criteria).getSession();
        } else if (criteria instanceof CriteriaImpl.Subcriteria) {
            CriteriaImpl temp = (CriteriaImpl)((CriteriaImpl.Subcriteria)criteria).getParent();
            session = temp.getSession();
        }
        return session;
    }

    private static CriteriaImpl getCriteriaImpl(Criteria criteria) {
        if (criteria instanceof CriteriaImpl.Subcriteria) {
            return (CriteriaImpl)((CriteriaImpl.Subcriteria)criteria).getParent();
        }
        if (criteria instanceof CriteriaImpl) {
            return (CriteriaImpl)criteria;
        }
        return null;
    }
}

