/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.count.CountValue;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.CountDatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="count", datasetEntityType=CountDatasetEntity.class)
public class CountDataRepository
extends AbstractDataRepository<CountDatasetEntity, CountDataEntity, CountValue, Integer> {
    @Override
    protected Data<CountValue> assembleData(CountDatasetEntity seriesEntity, DbQuery query, Session session) {
        Data result = new Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (CountDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.assembleDataValue(observation, seriesEntity, query));
        }
        return result;
    }

    @Override
    public CountValue assembleDataValue(CountDataEntity observation, CountDatasetEntity series, DbQuery query) {
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity(series);
        Integer observationValue = !service.isNoDataValue(observation) ? (Integer)observation.getValue() : null;
        IoParameters parameters = query.getParameters();
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        CountValue value = parameters.isShowTimeIntervals() ? new CountValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new CountValue(Long.valueOf(end), observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }
}

