/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.record.RecordValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.RecordDataEntity;
import org.n52.series.db.beans.RecordDatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="record", datasetEntityType=RecordDatasetEntity.class)
public class RecordDataRepository
extends AbstractDataRepository<RecordDatasetEntity, RecordDataEntity, RecordValue, Map<String, Object>> {
    @Override
    protected Data<RecordValue> assembleData(RecordDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (RecordDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.assembleDataValue(observation, seriesEntity, query));
        }
        return result;
    }

    @Override
    public RecordValue assembleDataValue(RecordDataEntity observation, RecordDatasetEntity series, DbQuery query) {
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity(series);
        Map observationValue = !service.isNoDataValue(observation) ? (Map)observation.getValue() : null;
        Date timeend = observation.getTimeend();
        Date timestart = observation.getTimestart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        RecordValue value = parameters.isShowTimeIntervals() ? new RecordValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new RecordValue(Long.valueOf(end), observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }
}

