/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.I18nFeatureEntity;
import org.n52.series.db.beans.I18nOfferingEntity;
import org.n52.series.db.beans.I18nPhenomenonEntity;
import org.n52.series.db.beans.I18nProcedureEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.QueryUtils;
import org.n52.series.db.dao.SearchableDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DatasetDao<T extends DatasetEntity>
extends AbstractDao<T>
implements SearchableDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetDao.class);
    private static final String COLUMN_PKID = "pkid";
    private static final String FEATURE_PATH_ALIAS = "dsFeature";
    private static final String PROCEDURE_PATH_ALIAS = "dsProcedure";
    private final Class<T> entityType;

    public DatasetDao(Session session) {
        this(session, DatasetEntity.class);
    }

    public DatasetDao(Session session, Class<T> clazz) {
        super(session);
        this.entityType = clazz;
    }

    @Override
    public List<T> find(DbQuery query) {
        Criteria criteria;
        LOGGER.debug("find entities: {}", (Object)query);
        ArrayList series = new ArrayList();
        String searchTerm = "%" + query.getSearchTerm() + "%";
        Criteria featureCriteria = criteria = this.getDefaultCriteria("s", query);
        featureCriteria = this.i18n(I18nFeatureEntity.class, featureCriteria, query);
        String featureName = QueryUtils.createAssociation(FEATURE_PATH_ALIAS, "name");
        featureCriteria.add(Restrictions.ilike((String)featureName, (Object)searchTerm));
        series.addAll(featureCriteria.list());
        Criteria procedureCriteria = criteria;
        procedureCriteria = this.i18n(I18nProcedureEntity.class, procedureCriteria, query);
        String procedureName = QueryUtils.createAssociation(PROCEDURE_PATH_ALIAS, "name");
        procedureCriteria.add(Restrictions.ilike((String)procedureName, (Object)searchTerm));
        series.addAll(procedureCriteria.list());
        Criteria offeringCriteria = criteria.createCriteria("offering", JoinType.LEFT_OUTER_JOIN);
        offeringCriteria = this.i18n(I18nOfferingEntity.class, offeringCriteria, query);
        offeringCriteria.add(Restrictions.ilike((String)"name", (Object)searchTerm));
        series.addAll(offeringCriteria.list());
        Criteria phenomenonCriteria = criteria.createCriteria("phenomenon", JoinType.LEFT_OUTER_JOIN);
        phenomenonCriteria = this.i18n(I18nPhenomenonEntity.class, phenomenonCriteria, query);
        phenomenonCriteria.add(Restrictions.ilike((String)"name", (Object)searchTerm));
        series.addAll(phenomenonCriteria.list());
        return series;
    }

    @Override
    public T getInstance(Long key, DbQuery query) throws DataAccessException {
        Criteria criteria = this.getDefaultCriteria(this.getDefaultAlias(), false, query);
        return (T)((DatasetEntity)criteria.add((Criterion)Restrictions.eq((String)COLUMN_PKID, (Object)key)).uniqueResult());
    }

    @Override
    protected T getInstance(String key, DbQuery query, Class<T> clazz) {
        return (T)((DatasetEntity)super.getInstance(key, query, clazz, this.getDefaultCriteria(null, false, query, clazz)));
    }

    @Override
    public List<T> getAllInstances(DbQuery query) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)query);
        Criteria criteria = query.addFilters(this.getDefaultCriteria(query), this.getDatasetProperty());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(DatasetDao.toSQLString(criteria));
        }
        return criteria.list();
    }

    public List<T> getInstancesWith(FeatureEntity feature, DbQuery query) {
        LOGGER.debug("get instance for feature '{}'", (Object)feature);
        Criteria criteria = this.getDefaultCriteria(query);
        String idColumn = QueryUtils.createAssociation(FEATURE_PATH_ALIAS, COLUMN_PKID);
        return criteria.add((Criterion)Restrictions.eq((String)idColumn, (Object)feature.getPkid())).list();
    }

    @Override
    protected Class<T> getEntityClass() {
        return this.entityType;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }

    @Override
    protected String getDefaultAlias() {
        return "dataset";
    }

    @Override
    protected Criteria getDefaultCriteria(String alias, DbQuery query, Class<?> clazz) {
        return this.getDefaultCriteria(alias, true, query, clazz);
    }

    private Criteria getDefaultCriteria(String alias, boolean ignoreReferenceSeries, DbQuery query) {
        return this.getDefaultCriteria(alias, ignoreReferenceSeries, query, this.getEntityClass());
    }

    private Criteria getDefaultCriteria(String alias, boolean ignoreReferenceSeries, DbQuery query, Class<?> clazz) {
        Criteria criteria = super.getDefaultCriteria(alias, query, clazz);
        if (ignoreReferenceSeries) {
            criteria.createCriteria("procedure", PROCEDURE_PATH_ALIAS, JoinType.LEFT_OUTER_JOIN).add((Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)).add((Criterion)Restrictions.eq((String)"reference", (Object)Boolean.FALSE));
        }
        query.addOdataFilterForDataset(criteria);
        return criteria;
    }

    @Override
    protected Criteria addDatasetFilters(DbQuery query, Criteria criteria) {
        Criteria filter = criteria.add((Criterion)this.createPublishedDatasetFilter());
        query.addSpatialFilter(filter.createCriteria("feature", FEATURE_PATH_ALIAS, JoinType.LEFT_OUTER_JOIN));
        return criteria;
    }
}

