/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class QueryUtils {
    static final String PROPERTY_PKID = "pkid";

    public static String createAssociation(String alias, String property) {
        return alias != null && !alias.isEmpty() ? alias + "." + property : property;
    }

    public static Set<Long> parseToIds(Set<String> ids) {
        return ids.stream().map(e -> QueryUtils.parseToId(e)).collect(Collectors.toSet());
    }

    public static SimpleExpression matchesPkid(String pkid) {
        return Restrictions.eq((String)PROPERTY_PKID, (Object)QueryUtils.parseToId(pkid));
    }

    public static Long parseToId(String id) {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            return Long.MIN_VALUE;
        }
    }
}

