/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.srv;

import org.n52.io.TvpDataCollection;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.ValueType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.DatasetRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.srv.DataService;
import org.n52.series.srv.AccessService;
import org.n52.web.exception.InternalServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetAccessService<V extends AbstractValue<?>>
extends AccessService<DatasetOutput<V>>
implements DataService<Data<V>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetAccessService.class);
    @Autowired
    private DataRepositoryTypeFactory dataFactory;

    public DatasetAccessService(DatasetRepository<V> repository) {
        super(repository);
    }

    public DataCollection<Data<V>> getData(IoParameters parameters) {
        try {
            TvpDataCollection dataCollection = new TvpDataCollection();
            for (String seriesId : parameters.getDatasets()) {
                Data<V> data = this.getDataFor(seriesId, parameters);
                if (data == null) continue;
                dataCollection.addNewSeries(seriesId, data);
            }
            return dataCollection;
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not get series data from database.", (Throwable)e);
        }
    }

    private Data<V> getDataFor(String datasetId, IoParameters parameters) throws DataAccessException {
        DbQuery dbQuery = this.dbQueryFactory.createFrom(parameters);
        String handleAsDatasetFallback = parameters.getAsString("handleAs");
        String valueType = ValueType.extractType((String)datasetId, (String)handleAsDatasetFallback);
        if (!"all".equalsIgnoreCase(valueType) && !this.dataFactory.isKnown(valueType)) {
            LOGGER.debug("unknown type: " + valueType);
            return new Data();
        }
        Class<? extends DatasetEntity> entityType = this.dataFactory.getDatasetEntityType(valueType);
        DataRepository assembler = this.dataFactory.create(valueType, entityType);
        return assembler.getData(datasetId, dbQuery);
    }
}

