/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension.metadata;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.n52.io.extension.metadata.MetadataEntity;

public class DatabaseMetadataDao {
    private final Session session;

    public DatabaseMetadataDao(Session session) {
        this.session = session;
    }

    public MetadataEntity<?> getInstance(Long key) {
        return (MetadataEntity)this.session.get(MetadataEntity.class, (Serializable)key);
    }

    public List<MetadataEntity<?>> getAllFor(Long id) {
        Criteria criteria = this.session.createCriteria(MetadataEntity.class).add((Criterion)Restrictions.eq((String)"seriesId", (Object)id));
        return criteria.list();
    }

    List<MetadataEntity<?>> getSelected(Long id, Set<String> fields) {
        Criteria criteria = this.session.createCriteria(MetadataEntity.class).add((Criterion)Restrictions.eq((String)"seriesId", (Object)id));
        this.addCaseInsensitivePropertyMatch(criteria, fields);
        return criteria.list();
    }

    private void addCaseInsensitivePropertyMatch(Criteria criteria, Set<String> fields) {
        Disjunction disjunction = Restrictions.disjunction();
        for (String field : fields) {
            disjunction.add((Criterion)Restrictions.eq((String)"name", (Object)field).ignoreCase());
        }
        criteria.add((Criterion)disjunction);
    }

    List<String> getMetadataNames(Long id) {
        Criteria criteria = this.session.createCriteria(MetadataEntity.class).add((Criterion)Restrictions.eq((String)"seriesId", (Object)id)).setProjection((Projection)Projections.property((String)"name"));
        return criteria.list();
    }
}

