/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ParameterOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.SearchableRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.SearchableDao;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.ResourceNotFoundException;

public abstract class ParameterRepository<E extends DescribableEntity, O extends ParameterOutput>
extends SessionAwareRepository
implements SearchableRepository,
OutputAssembler<O> {
    protected abstract O prepareEmptyParameterOutput(E var1);

    protected abstract SearchResult createEmptySearchResult(String var1, String var2, String var3);

    protected abstract AbstractDao<E> createDao(Session var1);

    protected abstract SearchableDao<E> createSearchableDao(Session var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery query) {
        Session session = this.getSession();
        try {
            AbstractDao<E> dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), query);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<O> getAllCondensed(DbQuery query) {
        Session session = this.getSession();
        try {
            List<O> list = this.getAllCondensed(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<O> getAllCondensed(DbQuery query, Session session) {
        List<E> allInstances = this.getAllInstances(query, session);
        O results = this.createCondensed((E)allInstances, query, session);
        return results;
    }

    protected List<O> createCondensed(Iterable<E> allInstances, DbQuery query, Session session) {
        ArrayList<O> results = new ArrayList<O>();
        for (DescribableEntity entity : allInstances) {
            results.add(this.createCondensed(entity, query, session));
        }
        return results;
    }

    protected O createCondensed(E entity, DbQuery query, Session session) {
        O result = this.prepareEmptyParameterOutput(entity);
        IoParameters parameters = query.getParameters();
        Long pkid = ((DescribableEntity)entity).getPkid();
        String label = ((DescribableEntity)entity).getLabelFrom(query.getLocale());
        String domainId = ((DescribableEntity)entity).getDomainId();
        String hrefBase = query.getHrefBase();
        result.setId(Long.toString(pkid));
        result.setValue("label", (Object)label, parameters, arg_0 -> result.setLabel(arg_0));
        result.setValue("domainid", (Object)domainId, parameters, arg_0 -> result.setDomainId(arg_0));
        result.setValue("href", (Object)hrefBase, parameters, arg_0 -> result.setHrefBase(arg_0));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<O> getAllExpanded(DbQuery query) {
        Session session = this.getSession();
        try {
            List<O> list = this.getAllExpanded(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<O> getAllExpanded(DbQuery query, Session session) {
        List<E> allInstances = this.getAllInstances(query, session);
        return this.createExpanded(allInstances, query, session);
    }

    protected abstract O createExpanded(E var1, DbQuery var2, Session var3);

    protected List<O> createExpanded(Iterable<E> allInstances, DbQuery query, Session session) throws DataAccessException {
        ArrayList<O> results = new ArrayList<O>();
        for (DescribableEntity entity : allInstances) {
            O instance = this.createExpanded(entity, query, session);
            if (instance == null) continue;
            results.add(instance);
        }
        return results;
    }

    protected List<E> getAllInstances(DbQuery parameters, Session session) {
        return this.createDao(session).getAllInstances(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public O getInstance(String id, DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            O o = this.getInstance(id, query, session);
            return o;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public O getInstance(String id, DbQuery query, Session session) {
        AbstractDao<E> dao = this.createDao(session);
        E entity = this.getEntity(this.parseId(id), dao, query);
        return this.createExpanded(entity, query, session);
    }

    protected E getInstance(Long id, DbQuery query, Session session) {
        AbstractDao<E> dao = this.createDao(session);
        return this.getEntity(id, dao, query);
    }

    protected E getEntity(Long id, AbstractDao<E> dao, DbQuery query) {
        DescribableEntity entity = (DescribableEntity)dao.getInstance(id, query);
        if (entity == null) {
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
        return (E)entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            SearchableDao<E> dao = this.createSearchableDao(session);
            DbQuery query = this.getDbQuery(parameters);
            List<E> found = dao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    protected List<SearchResult> convertToSearchResults(List<E> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = query.getHrefBase();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity searchResult : found) {
            String label = searchResult.getLabelFrom(locale);
            String pkid = Long.toString(searchResult.getPkid());
            results.add(this.createEmptySearchResult(pkid, label, hrefBase));
        }
        return results;
    }
}

