/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db;

import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimestampTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.n52.series.db.ZonalTimestampTypeDescriptor;

public class ZonalTimestampType
extends AbstractSingleColumnStandardBasicType<Date>
implements VersionType<Date>,
LiteralType<Date> {
    private static final long serialVersionUID = 1425445989380765998L;

    public ZonalTimestampType() {
        this(TimeZone.getTimeZone("UTC"));
    }

    public ZonalTimestampType(TimeZone zone) {
        super((SqlTypeDescriptor)ZonalTimestampTypeDescriptor.getInstance(zone), (JavaTypeDescriptor)JdbcTimestampTypeDescriptor.INSTANCE);
    }

    public String getName() {
        return TimestampType.INSTANCE.getName();
    }

    public String[] getRegistrationKeys() {
        return TimestampType.INSTANCE.getRegistrationKeys();
    }

    public Date next(Date current, SharedSessionContractImplementor session) {
        return TimestampType.INSTANCE.next(current, session);
    }

    public Date seed(SharedSessionContractImplementor session) {
        return TimestampType.INSTANCE.seed(session);
    }

    public Comparator<Date> getComparator() {
        return TimestampType.INSTANCE.getComparator();
    }

    public String objectToSQLString(Date value, Dialect dialect) throws Exception {
        return TimestampType.INSTANCE.objectToSQLString(value, dialect);
    }

    public Date fromStringValue(String xml) throws HibernateException {
        return TimestampType.INSTANCE.fromStringValue(xml);
    }
}

