/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEntity
extends DescribableEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceEntity.class);
    private String url;
    private String version;
    private List<String> noDataValues = Collections.emptyList();
    private String type = "Thin DB access layer service.";
    private boolean supportsFirstLatest = true;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public boolean isNoDataValue(DataEntity<?> observation) {
        return observation == null || observation.isNoDataValue(this.noDataValues);
    }

    public String getNoDataValues() {
        String csv = Arrays.toString((Object[])this.noDataValues.toArray(new Double[0]));
        return csv.substring(1).substring(0, csv.length() - 2);
    }

    public void setNoDataValues(String noDataValues) {
        LOGGER.debug("Set noData values: {}", (Object)noDataValues);
        if (noDataValues == null || noDataValues.isEmpty()) {
            this.noDataValues = Collections.emptyList();
        } else {
            String[] values = noDataValues.split(",");
            this.noDataValues = Arrays.asList(values);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSupportsFirstLatest() {
        return this.supportsFirstLatest;
    }

    public void setSupportsFirstLatest(boolean supportsFirstLatest) {
        this.supportsFirstLatest = supportsFirstLatest;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append(" url: ").append(this.getUrl());
        sb.append(", type: ").append(this.getType());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", noDataValues: ").append(this.getNoDataValues());
        return sb.append(" ]").toString();
    }
}

