/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.n52.series.db.beans.DataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantityDataEntity
extends DataEntity<BigDecimal> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuantityDataEntity.class);
    private static final BigDecimal DOUBLE_THRESHOLD = new BigDecimal(1.0E-4);

    @Override
    public boolean isNoDataValue(Collection<String> noDataValues) {
        BigDecimal value = (BigDecimal)this.getValue();
        return value == null || this.containsValue(noDataValues, value);
    }

    private boolean containsValue(Collection<String> collection, BigDecimal key) {
        if (collection == null) {
            return false;
        }
        for (BigDecimal noDataValue : this.convert(collection)) {
            if (noDataValue.subtract(key).abs().compareTo(DOUBLE_THRESHOLD) >= 0) continue;
            return true;
        }
        return false;
    }

    private Collection<BigDecimal> convert(Collection<String> collection) {
        ArrayList<BigDecimal> validatedValues = new ArrayList<BigDecimal>();
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                validatedValues.add(new BigDecimal(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Ignoring NO_DATA value {} (not a big decimal value).", (Object)trimmed);
            }
        }
        return validatedValues;
    }
}

