/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.geolatte.geom.GeometryType;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.spatial.criterion.SpatialRestrictions;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataModelUtil;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.I18nEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.GenericDao;
import org.n52.series.db.dao.QueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDao<T>
implements GenericDao<T, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDao.class);
    protected final Session session;

    public AbstractDao(Session session) {
        if (session == null) {
            throw new NullPointerException("Cannot operate on a null session.");
        }
        this.session = session;
    }

    protected abstract Class<T> getEntityClass();

    protected abstract String getDatasetProperty();

    protected String getDefaultAlias() {
        return this.getDatasetProperty();
    }

    @Override
    public boolean hasInstance(String id, DbQuery query) throws DataAccessException {
        return this.getInstance(id, query) != null;
    }

    public boolean hasInstance(String id, DbQuery query, Class<?> clazz) throws DataAccessException {
        return this.getInstance(id, query) != null;
    }

    @Override
    public boolean hasInstance(Long id, DbQuery query) {
        return this.session.get(this.getEntityClass(), (Serializable)id) != null;
    }

    public boolean hasInstance(Long id, DbQuery query, Class<?> clazz) {
        return this.session.get(clazz, (Serializable)id) != null;
    }

    @Override
    public T getInstance(String key, DbQuery query) throws DataAccessException {
        return this.getInstance(key, query, this.getEntityClass());
    }

    @Override
    public T getInstance(Long key, DbQuery query) throws DataAccessException {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)query);
        return this.getInstance(Long.toString(key), query, this.getEntityClass());
    }

    protected T getInstance(String key, DbQuery query, Class<T> clazz) {
        LOGGER.debug("get instance for '{}'. {}", (Object)key, (Object)query);
        Criteria criteria = this.getDefaultCriteria(query, clazz);
        return this.getInstance(key, query, clazz, criteria);
    }

    protected T getInstance(String key, DbQuery query, Class<T> clazz, Criteria criteria) {
        Criteria instanceCriteria = query.isMatchDomainIds() ? criteria.add((Criterion)Restrictions.eq((String)"domainId", (Object)key)) : criteria.add((Criterion)Restrictions.eq((String)"pkid", (Object)Long.parseLong(key)));
        return clazz.cast(instanceCriteria.uniqueResult());
    }

    @Override
    public Integer getCount(DbQuery query) throws DataAccessException {
        Criteria criteria = this.getDefaultCriteria(query).setProjection(Projections.rowCount());
        Object result = criteria.uniqueResult();
        if (result == null) {
            String sql = DataModelUtil.getSqlString(criteria);
            LOGGER.error("Please review query: {}", (Object)sql);
            return 0;
        }
        return ((Long)result).intValue();
    }

    protected <I extends I18nEntity> Criteria i18n(Class<I> clazz, Criteria criteria, DbQuery query) {
        return this.hasTranslation(query, clazz) ? query.addLocaleTo(criteria, clazz) : criteria;
    }

    private <I extends I18nEntity> boolean hasTranslation(DbQuery parameters, Class<I> clazz) {
        Criteria i18nCriteria = this.session.createCriteria(clazz);
        return parameters.checkTranslationForLocale(i18nCriteria);
    }

    public Criteria getDefaultCriteria(DbQuery query) {
        return this.getDefaultCriteria((String)null, query);
    }

    public Criteria getDefaultCriteria(String alias, DbQuery query) {
        return this.getDefaultCriteria(alias, query, this.getEntityClass());
    }

    private Criteria getDefaultCriteria(DbQuery query, Class<?> clazz) {
        return this.getDefaultCriteria(null, query, clazz);
    }

    protected Criteria getDefaultCriteria(String alias, DbQuery query, Class<?> clazz) {
        String nonNullAlias = alias != null ? alias : this.getDefaultAlias();
        Criteria criteria = this.session.createCriteria(clazz, nonNullAlias);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        this.addDatasetFilters(query, criteria);
        this.addPlatformTypeFilter(this.getDatasetProperty(), criteria, query);
        this.addValueTypeFilter(this.getDatasetProperty(), criteria, query);
        this.addGeometryTypeFilter(query, criteria);
        return criteria;
    }

    protected Criteria addDatasetFilters(DbQuery query, Criteria criteria) {
        DetachedCriteria filter = this.createDatasetSubqueryViaExplicitJoin(query);
        return criteria.add(Subqueries.propertyIn((String)"pkid", (DetachedCriteria)filter));
    }

    private DetachedCriteria createDatasetSubqueryViaExplicitJoin(DbQuery query) {
        DetachedCriteria subquery = DetachedCriteria.forClass(DatasetEntity.class).add((Criterion)this.createPublishedDatasetFilter());
        if (this.getDatasetProperty().equalsIgnoreCase("feature")) {
            DetachedCriteria featureCriteria = this.addSpatialFilter(query, subquery);
            return featureCriteria.setProjection((Projection)Projections.property((String)"pkid"));
        }
        this.addSpatialFilter(query, subquery);
        return subquery.createCriteria(this.getDatasetProperty()).setProjection((Projection)Projections.property((String)"pkid"));
    }

    protected final Conjunction createPublishedDatasetFilter() {
        return Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"published", (Object)true), Restrictions.eq((String)"deleted", (Object)false), Restrictions.isNotNull((String)"firstValueAt"), Restrictions.isNotNull((String)"lastValueAt")});
    }

    protected DetachedCriteria addSpatialFilter(DbQuery query, DetachedCriteria criteria) {
        return query.addSpatialFilter(criteria.createCriteria("feature"));
    }

    protected Criteria addValueTypeFilter(String parameter, Criteria criteria, DbQuery query) {
        IoParameters parameters = query.getParameters();
        Set valueTypes = parameters.getValueTypes();
        if (!valueTypes.isEmpty()) {
            FilterResolver filterResolver = parameters.getFilterResolver();
            if (parameters.shallBehaveBackwardsCompatible() || !filterResolver.shallIncludeAllDatasetTypes()) {
                Criterion containsValueType = Restrictions.in((String)"valueType", (Collection)valueTypes);
                if (parameter == null || parameter.isEmpty()) {
                    criteria.add(containsValueType);
                } else {
                    ProjectionList onPkids = this.matchPropertyPkids("dataset", parameter);
                    DetachedCriteria c = DetachedCriteria.forClass(DatasetEntity.class, (String)"dataset").add(containsValueType).setProjection((Projection)onPkids);
                    criteria.add(this.matchPropertyPkids(parameter, c));
                }
            }
        }
        return criteria;
    }

    protected Criteria addPlatformTypeFilter(String parameter, Criteria criteria, DbQuery query) {
        IoParameters parameters = query.getParameters();
        FilterResolver filterResolver = parameters.getFilterResolver();
        if (!filterResolver.shallIncludeAllPlatformTypes()) {
            if (parameter == null || parameter.isEmpty()) {
                criteria.createCriteria("platform").add((Criterion)this.createMobileExpression(filterResolver)).add((Criterion)this.createInsituExpression(filterResolver));
            } else {
                DetachedCriteria c = DetachedCriteria.forClass(DatasetEntity.class, (String)"dataset").createCriteria("procedure").add((Criterion)this.createMobileExpression(filterResolver)).add((Criterion)this.createInsituExpression(filterResolver)).setProjection((Projection)this.matchPropertyPkids("dataset", parameter));
                criteria.add(this.matchPropertyPkids(parameter, c));
            }
        }
        return criteria;
    }

    private LogicalExpression createMobileExpression(FilterResolver filterResolver) {
        boolean includeStationary = filterResolver.shallIncludeStationaryPlatformTypes();
        boolean includeMobile = filterResolver.shallIncludeMobilePlatformTypes();
        return Restrictions.or((Criterion)Restrictions.eq((String)"mobile", (Object)(!includeStationary ? 1 : 0)), (Criterion)Restrictions.eq((String)"mobile", (Object)includeMobile));
    }

    private LogicalExpression createInsituExpression(FilterResolver filterResolver) {
        boolean includeInsitu = filterResolver.shallIncludeInsituPlatformTypes();
        boolean includeRemote = filterResolver.shallIncludeRemotePlatformTypes();
        return Restrictions.or((Criterion)Restrictions.eq((String)"insitu", (Object)includeInsitu), (Criterion)Restrictions.eq((String)"insitu", (Object)(!includeRemote ? 1 : 0)));
    }

    private ProjectionList matchPropertyPkids(String alias, String property) {
        String member = QueryUtils.createAssociation(alias, property);
        String association = QueryUtils.createAssociation(member, "pkid");
        return Projections.projectionList().add((Projection)Projections.property((String)association));
    }

    private Criterion matchPropertyPkids(String property, DetachedCriteria c) {
        return Subqueries.propertyIn((String)QueryUtils.createAssociation(property, "pkid"), (DetachedCriteria)c);
    }

    protected Criteria addGeometryTypeFilter(DbQuery query, Criteria criteria) {
        query.getParameters().getGeometryTypes().stream().filter(geometryType -> !geometryType.isEmpty()).map(this::getGeometryType).filter(Objects::nonNull).map(type -> SpatialRestrictions.geometryType((String)"geometryEntity", (GeometryType)type)).forEach(arg_0 -> ((Criteria)criteria).add(arg_0));
        return criteria;
    }

    private GeometryType getGeometryType(String geometryType) {
        return Arrays.stream(GeometryType.values()).filter(type -> type.name().equalsIgnoreCase(geometryType)).findAny().orElse(null);
    }

    public static String toSQLString(Criteria criteria) {
        if (!(criteria instanceof CriteriaImpl)) {
            return criteria.toString();
        }
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        SharedSessionContractImplementor session = criteriaImpl.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        String entityOrClassName = criteriaImpl.getEntityOrClassName();
        CriteriaQueryTranslator translator = new CriteriaQueryTranslator(factory, criteriaImpl, entityOrClassName, "this_");
        String[] implementors = factory.getImplementors(entityOrClassName);
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)factory.getEntityPersister(implementors[0]);
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        CriteriaJoinWalker walker = new CriteriaJoinWalker(outerJoinLoadable, translator, factory, criteriaImpl, entityOrClassName, loadQueryInfluencers);
        return walker.getSQLString();
    }
}

