/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.I18nProcedureEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.ParameterDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ProcedureDao
extends ParameterDao<ProcedureEntity, I18nProcedureEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureDao.class);
    private static final String COLUMN_REFERENCE = "reference";

    public ProcedureDao(Session session) {
        super(session);
    }

    @Override
    public ProcedureEntity getInstance(Long key, DbQuery query) throws DataAccessException {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)query);
        Criteria criteria = this.getDefaultCriteria(true, query);
        return this.getEntityClass().cast(criteria.add((Criterion)Restrictions.eq((String)"pkid", (Object)key)).uniqueResult());
    }

    @Override
    public Criteria getDefaultCriteria(DbQuery query) {
        return this.getDefaultCriteria(true, query);
    }

    private Criteria getDefaultCriteria(boolean ignoreReferenceProcedures, DbQuery query) {
        return ignoreReferenceProcedures ? super.getDefaultCriteria(query).add((Criterion)Restrictions.eq((String)COLUMN_REFERENCE, (Object)Boolean.FALSE)) : super.getDefaultCriteria(query);
    }

    @Override
    protected String getDatasetProperty() {
        return "procedure";
    }

    @Override
    protected Class<ProcedureEntity> getEntityClass() {
        return ProcedureEntity.class;
    }

    @Override
    protected Class<I18nProcedureEntity> getI18NEntityClass() {
        return I18nProcedureEntity.class;
    }
}

