/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.StationOutput;
import org.n52.io.response.dataset.TimeseriesMetadataOutput;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.da.StationRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.search.SearchResult;
import org.n52.series.spi.search.TimeseriesSearchResult;
import org.n52.web.exception.ResourceNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Deprecated
public class TimeseriesRepository
extends SessionAwareRepository
implements OutputAssembler<TimeseriesMetadataOutput> {
    @Autowired
    @Qualifier(value="stationRepository")
    private OutputAssembler<StationOutput> stationRepository;
    @Autowired
    private DataRepository<QuantityDatasetEntity, QuantityDataEntity, QuantityValue, BigDecimal> repository;

    private DatasetDao<QuantityDatasetEntity> createDao(Session session) {
        return new DatasetDao<QuantityDatasetEntity>(session, QuantityDatasetEntity.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            DatasetDao<QuantityDatasetEntity> dao = this.createDao(session);
            boolean bl = dao.hasInstance(this.parseId(id), parameters, QuantityDatasetEntity.class);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        Session session = this.getSession();
        try {
            DatasetDao<QuantityDatasetEntity> seriesDao = this.createDao(session);
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            List<QuantityDatasetEntity> found = seriesDao.find(query);
            List<SearchResult> list = this.convertToResults(found, query.getLocale());
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    private List<SearchResult> convertToResults(List<QuantityDatasetEntity> found, String locale) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (QuantityDatasetEntity searchResult : found) {
            String pkid = searchResult.getPkid().toString();
            String phenomenonLabel = searchResult.getPhenomenon().getLabelFrom(locale);
            String procedureLabel = searchResult.getProcedure().getLabelFrom(locale);
            String stationLabel = searchResult.getFeature().getLabelFrom(locale);
            String offeringLabel = searchResult.getOffering().getLabelFrom(locale);
            String label = this.createTimeseriesLabel(phenomenonLabel, procedureLabel, stationLabel, offeringLabel);
            results.add((SearchResult)new TimeseriesSearchResult(pkid, label));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimeseriesMetadataOutput> getAllCondensed(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<TimeseriesMetadataOutput> list = this.getAllCondensed(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<TimeseriesMetadataOutput> getAllCondensed(DbQuery query, Session session) throws DataAccessException {
        ArrayList<TimeseriesMetadataOutput> results = new ArrayList<TimeseriesMetadataOutput>();
        DatasetDao<QuantityDatasetEntity> seriesDao = this.createDao(session);
        for (QuantityDatasetEntity timeseries : seriesDao.getAllInstances(query)) {
            results.add(this.createCondensed(timeseries, query, session));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimeseriesMetadataOutput> getAllExpanded(DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<TimeseriesMetadataOutput> list = this.getAllExpanded(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<TimeseriesMetadataOutput> getAllExpanded(DbQuery query, Session session) throws DataAccessException {
        ArrayList<TimeseriesMetadataOutput> results = new ArrayList<TimeseriesMetadataOutput>();
        DatasetDao<QuantityDatasetEntity> seriesDao = this.createDao(session);
        for (QuantityDatasetEntity timeseries : seriesDao.getAllInstances(query)) {
            results.add(this.createExpanded(timeseries, query, session));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeseriesMetadataOutput getInstance(String timeseriesId, DbQuery dbQuery) throws DataAccessException {
        Session session = this.getSession();
        try {
            TimeseriesMetadataOutput timeseriesMetadataOutput = this.getInstance(timeseriesId, dbQuery, session);
            return timeseriesMetadataOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public TimeseriesMetadataOutput getInstance(String timeseriesId, DbQuery dbQuery, Session session) throws DataAccessException {
        DatasetDao<QuantityDatasetEntity> seriesDao = this.createDao(session);
        QuantityDatasetEntity result = (QuantityDatasetEntity)seriesDao.getInstance(this.parseId(timeseriesId), dbQuery);
        if (result == null) {
            throw new ResourceNotFoundException("Resource with id '" + timeseriesId + "' could not be found.");
        }
        return this.createExpanded(result, dbQuery, session);
    }

    protected TimeseriesMetadataOutput createExpanded(QuantityDatasetEntity series, DbQuery query, Session session) throws DataAccessException {
        TimeseriesMetadataOutput result = this.createCondensed(series, query, session);
        List<ReferenceValueOutput<QuantityValue>> refValues = this.createReferenceValueOutputs(series, query);
        DatasetParameters timeseries = this.createTimeseriesOutput(series, query.withoutFieldsFilter());
        QuantityValue firstValue = this.repository.getFirstValue(series, session, query);
        QuantityValue lastValue = this.repository.getLastValue(series, session, query);
        IoParameters params = query.getParameters();
        result.setValue("referenceValues", refValues, params, arg_0 -> ((TimeseriesMetadataOutput)result).setReferenceValues(arg_0));
        result.setValue("parameters", (Object)timeseries, params, arg_0 -> ((TimeseriesMetadataOutput)result).setDatasetParameters(arg_0));
        result.setValue("firstValue", (Object)firstValue, params, arg_0 -> ((TimeseriesMetadataOutput)result).setFirstValue(arg_0));
        result.setValue("lastValue", (Object)lastValue, params, arg_0 -> ((TimeseriesMetadataOutput)result).setLastValue(arg_0));
        return result;
    }

    private List<ReferenceValueOutput<QuantityValue>> createReferenceValueOutputs(QuantityDatasetEntity series, DbQuery query) throws DataAccessException {
        ArrayList<ReferenceValueOutput<QuantityValue>> outputs = new ArrayList<ReferenceValueOutput<QuantityValue>>();
        List<QuantityDatasetEntity> referenceValues = series.getReferenceValues();
        for (QuantityDatasetEntity referenceSeriesEntity : referenceValues) {
            if (!referenceSeriesEntity.isPublished().booleanValue()) continue;
            ReferenceValueOutput refenceValueOutput = new ReferenceValueOutput();
            ProcedureEntity procedure = referenceSeriesEntity.getProcedure();
            refenceValueOutput.setLabel(procedure.getNameI18n(query.getLocale()));
            refenceValueOutput.setReferenceValueId(referenceSeriesEntity.getPkid().toString());
            QuantityDataEntity lastValue = (QuantityDataEntity)referenceSeriesEntity.getLastValue();
            refenceValueOutput.setLastValue((AbstractValue)this.repository.assembleDataValue(lastValue, referenceSeriesEntity, query));
            outputs.add((ReferenceValueOutput<QuantityValue>)refenceValueOutput);
        }
        return outputs;
    }

    private TimeseriesMetadataOutput createCondensed(QuantityDatasetEntity entity, DbQuery query, Session session) throws DataAccessException {
        IoParameters parameters = query.getParameters();
        TimeseriesMetadataOutput result = new TimeseriesMetadataOutput(parameters);
        String locale = query.getLocale();
        PhenomenonEntity phenomenon = entity.getPhenomenon();
        String phenomenonLabel = phenomenon.getLabelFrom(locale);
        ProcedureEntity procedure = entity.getProcedure();
        String procedureLabel = procedure.getLabelFrom(locale);
        FeatureEntity feature = entity.getFeature();
        String stationLabel = feature.getLabelFrom(locale);
        OfferingEntity offering = entity.getOffering();
        String offeringLabel = offering.getLabelFrom(locale);
        Long pkid = entity.getPkid();
        String uom = entity.getUnitI18nName(locale);
        String label = this.createTimeseriesLabel(phenomenonLabel, procedureLabel, stationLabel, offeringLabel);
        StationOutput station = this.createCondensedStation(entity, query.withoutFieldsFilter(), session);
        result.setId(pkid.toString());
        result.setValue("label", (Object)label, parameters, arg_0 -> ((TimeseriesMetadataOutput)result).setLabel(arg_0));
        result.setValue("uom", (Object)uom, parameters, arg_0 -> ((TimeseriesMetadataOutput)result).setUom(arg_0));
        result.setValue("station", (Object)station, parameters, arg_0 -> ((TimeseriesMetadataOutput)result).setStation(arg_0));
        return result;
    }

    private String createTimeseriesLabel(String phenomenon, String procedure, String station, String offering) {
        StringBuilder sb = new StringBuilder();
        sb.append(phenomenon).append(" ");
        sb.append(procedure).append(", ");
        sb.append(station).append(", ");
        return sb.append(offering).toString();
    }

    private StationOutput createCondensedStation(QuantityDatasetEntity entity, DbQuery query, Session session) throws DataAccessException {
        FeatureEntity feature = entity.getFeature();
        String featurePkid = Long.toString(feature.getPkid());
        return ((StationRepository)this.stationRepository).getCondensedInstance(featurePkid, query, session);
    }

    public OutputAssembler<StationOutput> getStationRepository() {
        return this.stationRepository;
    }

    public void setStationRepository(OutputAssembler<StationOutput> stationRepository) {
        this.stationRepository = stationRepository;
    }
}

