/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.SamplingGeometryEntity;
import org.n52.series.db.dao.DbQuery;

public class SamplingGeometryDao {
    private static final String COLUMN_SERIES_PKID = "seriesPkid";
    private static final String COLUMN_TIMESTAMP = "timestamp";
    private final Session session;

    public SamplingGeometryDao(Session session) {
        this.session = session;
    }

    public List<GeometryEntity> getGeometriesOrderedByTimestamp(DbQuery query) {
        Criteria criteria = this.session.createCriteria(SamplingGeometryEntity.class);
        criteria.add(Restrictions.in((String)COLUMN_SERIES_PKID, this.getDatasetIds(query)));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.addOrder(Order.asc((String)COLUMN_TIMESTAMP));
        query.addSpatialFilter(criteria);
        return this.toGeometryEntities(criteria.list());
    }

    private List<Long> getDatasetIds(DbQuery query) {
        Criteria criteria = this.session.createCriteria(DatasetEntity.class);
        criteria.setProjection((Projection)Projections.property((String)"pkid"));
        query.addDetachedFilters("", criteria);
        return criteria.list();
    }

    private List<GeometryEntity> toGeometryEntities(List<SamplingGeometryEntity> entities) {
        return entities.stream().map(e -> e.getGeometryEntity()).collect(Collectors.toList());
    }
}

