/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.n52.io.response.PlatformType;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.da.SessionAwareRepository;

public class SessionAwareRepositoryTest {
    @Test
    public void when_mobileInsituString_then_recognizeType() {
        String platformId = this.getPlatformId(42L, true, true);
        Assert.assertThat((Object)PlatformType.extractType((String)platformId), (Matcher)Matchers.is((Object)PlatformType.MOBILE_INSITU));
    }

    @Test
    public void when_mobileRemoteString_then_recognizeType() {
        String platformId = this.getPlatformId(42L, true, false);
        Assert.assertThat((Object)PlatformType.extractType((String)platformId), (Matcher)Matchers.is((Object)PlatformType.MOBILE_REMOTE));
    }

    @Test
    public void when_stationaryInsituString_then_recognizeType() {
        String platformId = this.getPlatformId(42L, false, true);
        Assert.assertThat((Object)PlatformType.extractType((String)platformId), (Matcher)Matchers.is((Object)PlatformType.STATIONARY_INSITU));
    }

    @Test
    public void when_stationaryRemoteString_then_recognizeType() {
        String platformId = this.getPlatformId(42L, false, false);
        Assert.assertThat((Object)PlatformType.extractType((String)platformId), (Matcher)Matchers.is((Object)PlatformType.STATIONARY_REMOTE));
    }

    private String getPlatformId(Long id, boolean mobile, boolean insitu) {
        ProcedureEntity procedure = new ProcedureEntity();
        procedure.setId(id);
        FeatureEntity feature = new FeatureEntity();
        feature.setId(id);
        QuantityDatasetEntity dataset = new QuantityDatasetEntity();
        dataset.setProcedure(procedure);
        dataset.setFeature((AbstractFeatureEntity)feature);
        dataset.setMobile(mobile);
        dataset.setInsitu(insitu);
        SessionAwareRepository repo = new SessionAwareRepository(){};
        return repo.getPlatformId((DatasetEntity)dataset);
    }
}

