/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.record.RecordValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.RecordDataEntity;
import org.n52.series.db.beans.RecordDatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.data.Data;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class RecordDataRepository
extends AbstractDataRepository<RecordDatasetEntity, RecordDataEntity, RecordValue> {
    @Override
    public Class<RecordDatasetEntity> getDatasetEntityType() {
        return RecordDatasetEntity.class;
    }

    @Override
    protected org.n52.io.response.dataset.Data<RecordValue> assembleData(RecordDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        org.n52.io.response.dataset.Data result = new org.n52.io.response.dataset.Data();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor((DatasetEntity)seriesEntity, query);
        for (RecordDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.createSeriesValueFor(observation, seriesEntity, query));
        }
        return result;
    }

    @Override
    protected RecordValue createEmptyValue() {
        return new RecordValue();
    }

    @Override
    public RecordValue createSeriesValueFor(RecordDataEntity observation, RecordDatasetEntity series, DbQuery query) {
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        Map observationValue = !service.isNoDataValue((Data)observation) ? (Map)observation.getValue() : null;
        RecordValue value = (RecordValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }
}

