/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.text.TextValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.beans.TextDatasetEntity;
import org.n52.series.db.beans.data.Data;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class TextDataRepository
extends AbstractDataRepository<TextDatasetEntity, TextDataEntity, TextValue> {
    @Override
    public Class<TextDatasetEntity> getDatasetEntityType() {
        return TextDatasetEntity.class;
    }

    @Override
    protected org.n52.io.response.dataset.Data<TextValue> assembleData(TextDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        org.n52.io.response.dataset.Data result = new org.n52.io.response.dataset.Data();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor((DatasetEntity)seriesEntity, query);
        for (TextDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.createSeriesValueFor(observation, seriesEntity, query));
        }
        return result;
    }

    @Override
    protected TextValue createEmptyValue() {
        return new TextValue();
    }

    @Override
    public TextValue createSeriesValueFor(TextDataEntity observation, TextDatasetEntity series, DbQuery query) {
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        String observationValue = !service.isNoDataValue((Data)observation) ? (String)observation.getValue() : null;
        TextValue value = (TextValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }

    TextValue createValue(String observationValue, TextDataEntity observation, DbQuery query) {
        TextValue value = (TextValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return value;
    }
}

