/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.geolatte.geom.GeometryType;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.spatial.criterion.SpatialRestrictions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.RootEntityResultTransformer;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.i18n.I18nEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.GenericDao;
import org.n52.series.db.dao.QueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDao<T>
implements GenericDao<T, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDao.class);
    protected final Session session;

    public AbstractDao(Session session) {
        if (session == null) {
            throw new NullPointerException("Cannot operate on a null session.");
        }
        this.session = session;
    }

    protected abstract Class<T> getEntityClass();

    protected abstract String getDatasetProperty();

    protected String getDefaultAlias() {
        return this.getDatasetProperty();
    }

    @Override
    public boolean hasInstance(String id, DbQuery query) {
        return this.getInstance(id, query) != null;
    }

    public boolean hasInstance(String id, DbQuery query, Class<?> clazz) {
        return this.getInstance(id, query) != null;
    }

    @Override
    public boolean hasInstance(Long id, DbQuery query) {
        return id != null ? this.hasInstance(id.toString(), query) : false;
    }

    public boolean hasInstance(Long id, DbQuery query, Class<?> clazz) {
        return id != null ? this.hasInstance(id.toString(), query, clazz) : false;
    }

    @Override
    public T getInstance(String key, DbQuery query) {
        return this.getInstance(key, query, this.getEntityClass());
    }

    @Override
    public T getInstance(Long key, DbQuery query) {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)query);
        return this.getInstance(Long.toString(key), query, this.getEntityClass());
    }

    protected T getInstance(String key, DbQuery query, Class<T> clazz) {
        LOGGER.debug("get instance for '{}'. {}", (Object)key, (Object)query);
        Criteria criteria = this.getDefaultCriteria(query, clazz);
        return this.getInstance(key, query, clazz, criteria);
    }

    protected T getInstance(String key, DbQuery query, Class<T> clazz, Criteria criteria) {
        Criteria instanceCriteria = query.isMatchDomainIds() ? criteria.add((Criterion)Restrictions.eq((String)"identifier", (Object)key)) : criteria.add((Criterion)Restrictions.eq((String)"id", (Object)Long.parseLong(key)));
        return clazz.cast(instanceCriteria.uniqueResult());
    }

    @Override
    public Integer getCount(DbQuery query) throws DataAccessException {
        Criteria criteria = this.getDefaultCriteria(query).setProjection(Projections.rowCount());
        return ((Long)criteria.uniqueResult()).intValue();
    }

    protected <I extends I18nEntity> Criteria i18n(Class<I> clazz, Criteria criteria, DbQuery query) {
        return this.hasTranslation(query, clazz) ? query.addLocaleTo(criteria, clazz) : criteria;
    }

    private <I extends I18nEntity> boolean hasTranslation(DbQuery parameters, Class<I> clazz) {
        Criteria i18nCriteria = this.session.createCriteria(clazz);
        return parameters.checkTranslationForLocale(i18nCriteria);
    }

    public Criteria getDefaultCriteria(DbQuery query) {
        return this.getDefaultCriteria((String)null, query);
    }

    public Criteria getDefaultCriteria(String alias, DbQuery query) {
        return this.getDefaultCriteria(alias, query, this.getEntityClass());
    }

    private Criteria getDefaultCriteria(DbQuery query, Class<?> clazz) {
        return this.getDefaultCriteria(null, query, clazz);
    }

    protected Criteria getDefaultCriteria(String alias, DbQuery query, Class<?> clazz) {
        String nonNullAlias = alias != null ? alias : this.getDefaultAlias();
        Criteria criteria = this.session.createCriteria(clazz, nonNullAlias);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        this.addDatasetFilters(query, criteria);
        this.addPlatformTypeFilter(this.getDatasetProperty(), criteria, query);
        this.addValueTypeFilter(this.getDatasetProperty(), criteria, query);
        this.addGeometryTypeFilter(query, criteria);
        return criteria;
    }

    protected Criteria addDatasetFilters(DbQuery query, Criteria criteria) {
        DetachedCriteria filter = this.createDatasetSubqueryViaExplicitJoin(query);
        return criteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)filter));
    }

    private DetachedCriteria createDatasetSubqueryViaExplicitJoin(DbQuery query) {
        DetachedCriteria subquery = DetachedCriteria.forClass(DatasetEntity.class).add((Criterion)this.createPublishedDatasetFilter());
        if (this.getDatasetProperty().equalsIgnoreCase("feature")) {
            DetachedCriteria featureCriteria = this.addSpatialFilter(query, subquery);
            return featureCriteria.setProjection((Projection)Projections.property((String)"id"));
        }
        this.addSpatialFilter(query, subquery);
        return subquery.createCriteria(this.getDatasetProperty()).setProjection((Projection)Projections.property((String)"id"));
    }

    protected final Conjunction createPublishedDatasetFilter() {
        return Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"published", (Object)true), Restrictions.eq((String)"deleted", (Object)false), Restrictions.isNotNull((String)"firstValueAt"), Restrictions.isNotNull((String)"lastValueAt")});
    }

    protected DetachedCriteria addSpatialFilter(DbQuery query, DetachedCriteria criteria) {
        return query.addSpatialFilter(criteria.createCriteria("feature"));
    }

    protected Criteria addValueTypeFilter(String parameter, Criteria criteria, DbQuery query) {
        IoParameters parameters = query.getParameters();
        Set valueTypes = parameters.getValueTypes();
        if (!valueTypes.isEmpty()) {
            FilterResolver filterResolver = parameters.getFilterResolver();
            if (parameters.shallBehaveBackwardsCompatible() || !filterResolver.shallIncludeAllDatasetTypes()) {
                if (parameter == null || parameter.isEmpty()) {
                    criteria.add(Restrictions.in((String)"valueType", (Collection)valueTypes));
                } else {
                    DetachedCriteria c = DetachedCriteria.forClass(DatasetEntity.class);
                    c.add(Restrictions.in((String)"valueType", (Collection)valueTypes));
                    QueryUtils.setFilterProjectionOn(parameter, c);
                    criteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)c));
                }
            }
        }
        return criteria;
    }

    protected Criteria addPlatformTypeFilter(String parameter, Criteria criteria, DbQuery query) {
        IoParameters parameters = query.getParameters();
        FilterResolver filterResolver = parameters.getFilterResolver();
        if (!filterResolver.shallIncludeAllPlatformTypes()) {
            if (parameter == null || parameter.isEmpty()) {
                criteria.add((Criterion)this.createPlatformTypeRestriction(filterResolver));
            } else {
                DetachedCriteria c = DetachedCriteria.forClass(DatasetEntity.class);
                c.add((Criterion)this.createPlatformTypeRestriction(filterResolver));
                QueryUtils.setFilterProjectionOn(parameter, c);
                criteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)c));
            }
        }
        return criteria;
    }

    private LogicalExpression createPlatformTypeRestriction(FilterResolver filterResolver) {
        return this.createPlatformTypeRestriction(null, filterResolver);
    }

    private LogicalExpression createPlatformTypeRestriction(String alias, FilterResolver filterResolver) {
        return Restrictions.and((Criterion)this.createMobileExpression(alias, filterResolver), (Criterion)this.createInsituExpression(alias, filterResolver));
    }

    private LogicalExpression createMobileExpression(String alias, FilterResolver filterResolver) {
        boolean includeStationary = filterResolver.shallIncludeStationaryPlatformTypes();
        boolean includeMobile = filterResolver.shallIncludeMobilePlatformTypes();
        String propertyMobile = QueryUtils.createAssociation(alias, "mobile");
        return Restrictions.or((Criterion)Restrictions.eq((String)propertyMobile, (Object)(!includeStationary ? 1 : 0)), (Criterion)Restrictions.eq((String)propertyMobile, (Object)includeMobile));
    }

    private LogicalExpression createInsituExpression(String alias, FilterResolver filterResolver) {
        boolean includeInsitu = filterResolver.shallIncludeInsituPlatformTypes();
        boolean includeRemote = filterResolver.shallIncludeRemotePlatformTypes();
        String propertyInsitu = QueryUtils.createAssociation(alias, "insitu");
        return Restrictions.or((Criterion)Restrictions.eq((String)propertyInsitu, (Object)includeInsitu), (Criterion)Restrictions.eq((String)propertyInsitu, (Object)(!includeRemote ? 1 : 0)));
    }

    protected Criteria addGeometryTypeFilter(DbQuery query, Criteria criteria) {
        query.getParameters().getGeometryTypes().stream().filter(geometryType -> !geometryType.isEmpty()).map(this::getGeometryType).filter(Objects::nonNull).map(type -> SpatialRestrictions.geometryType((String)"geometryEntity", (GeometryType)type)).forEach(arg_0 -> ((Criteria)criteria).add(arg_0));
        return criteria;
    }

    private GeometryType getGeometryType(String geometryType) {
        return Arrays.stream(GeometryType.values()).filter(type -> type.name().equalsIgnoreCase(geometryType)).findAny().orElse(null);
    }

    public static String toSQLString(Criteria criteria) {
        if (!(criteria instanceof CriteriaImpl)) {
            return criteria.toString();
        }
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        SharedSessionContractImplementor sessionContractImpl = criteriaImpl.getSession();
        SessionFactoryImplementor factory = sessionContractImpl.getFactory();
        String entityOrClassName = criteriaImpl.getEntityOrClassName();
        CriteriaQueryTranslator translator = new CriteriaQueryTranslator(factory, criteriaImpl, entityOrClassName, "this_");
        String[] implementors = factory.getImplementors(entityOrClassName);
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)factory.getEntityPersister(implementors[0]);
        LoadQueryInfluencers loadQueryInfluencers = sessionContractImpl.getLoadQueryInfluencers();
        CriteriaJoinWalker walker = new CriteriaJoinWalker(outerJoinLoadable, translator, factory, criteriaImpl, entityOrClassName, loadQueryInfluencers);
        return walker.getSQLString();
    }

    @Deprecated
    public Collection<T> get(DbQuery query) {
        Criteria c = this.session.createCriteria(this.getEntityClass(), this.getDefaultAlias()).setResultTransformer((ResultTransformer)RootEntityResultTransformer.INSTANCE);
        DetachedCriteria subquery = DetachedCriteria.forClass(DatasetEntity.class);
        subquery.add((Criterion)Restrictions.eq((String)"deleted", (Object)false));
        query.addFilters(c, this.getDatasetProperty());
        return c.list();
    }
}

