/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.joda.time.DateTime;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.QueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DataDao<T extends DataEntity>
extends AbstractDao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataDao.class);
    private final Class<T> entityType;

    public DataDao(Session session) {
        this(session, DataEntity.class);
    }

    public DataDao(Session session, Class<T> clazz) {
        super(session);
        this.entityType = clazz;
    }

    @Override
    public T getInstance(Long key, DbQuery parameters) {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)parameters);
        return (T)((DataEntity)this.entityType.cast(this.session.get(this.entityType, (Serializable)key)));
    }

    @Override
    public List<T> getAllInstances(DbQuery parameters) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)parameters);
        Criteria criteria = this.getDefaultCriteria(parameters);
        parameters.addTimespanTo(criteria);
        return criteria.list();
    }

    public List<T> getAllInstancesFor(DatasetEntity series, DbQuery query) throws DataAccessException {
        Long id = series.getId();
        LOGGER.debug("get all instances for series '{}': {}", (Object)id, (Object)query);
        Criteria criteria = query.addTimespanTo(this.getDefaultCriteria(query));
        return criteria.createCriteria("dataset").add((Criterion)Restrictions.eq((String)"id", (Object)id)).list();
    }

    @Override
    protected Class<T> getEntityClass() {
        return this.entityType;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }

    @Override
    public Criteria getDefaultCriteria(DbQuery query) {
        Criteria criteria = this.session.createCriteria(this.entityType).addOrder(Order.asc((String)"samplingTimeEnd")).add((Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        query.addSpatialFilter(criteria);
        query.addResultTimeFilter(criteria);
        query.addOdataFilterForData(criteria);
        criteria = query.isComplexParent() ? criteria.add((Criterion)Restrictions.eq((String)"parent", (Object)true)) : criteria.add((Criterion)Restrictions.eq((String)"parent", (Object)false));
        return criteria;
    }

    @Deprecated
    public T getDataValueViaTimeend(DatasetEntity series, DbQuery query) {
        Date timeend = series.getLastValueAt();
        Criteria criteria = this.createDataAtCriteria(timeend, "samplingTimeEnd", series, query);
        return (T)((DataEntity)criteria.uniqueResult());
    }

    @Deprecated
    public T getDataValueViaTimestart(DatasetEntity series, DbQuery query) {
        Date timestart = series.getFirstValueAt();
        Criteria criteria = this.createDataAtCriteria(timestart, "samplingTimeStart", series, query);
        return (T)((DataEntity)criteria.uniqueResult());
    }

    @Deprecated
    public GeometryEntity getValueGeometryViaTimeend(DatasetEntity series, DbQuery query) {
        Date lastValueAt = series.getLastValueAt();
        Criteria criteria = this.createDataAtCriteria(lastValueAt, "samplingTimeEnd", series, query);
        criteria.setProjection((Projection)Projections.property((String)"geometryEntity"));
        return (GeometryEntity)criteria.uniqueResult();
    }

    private Criteria createDataAtCriteria(Date timestamp, String column, DatasetEntity dataset, DbQuery query) {
        LOGGER.debug("get data @{} for '{}'", (Object)new DateTime(timestamp.getTime()), (Object)dataset.getId());
        String dsAlias = "dataset";
        String dsId = QueryUtils.createAssociation(dsAlias, "id");
        Criteria criteria = this.getDefaultCriteria(query).add((Criterion)Restrictions.eq((String)column, (Object)timestamp));
        criteria.createCriteria("dataset", dsAlias).add((Criterion)Restrictions.eq((String)dsId, (Object)dataset.getId()));
        IoParameters parameters = query.getParameters();
        if (parameters.isAllResultTimes()) {
            return criteria;
        }
        if (!parameters.getResultTimes().isEmpty()) {
            return query.addResultTimeFilter(criteria);
        }
        String rtAlias = "rt";
        String rtDatasetAlias = "rtDataset";
        String rtColumn = QueryUtils.createAssociation(rtAlias, column);
        String rtResultTime = QueryUtils.createAssociation(rtAlias, "resultTime");
        String rtDatasetId = QueryUtils.createAssociation(rtDatasetAlias, "id");
        DetachedCriteria resultTimeQuery = DetachedCriteria.forClass(this.getEntityClass(), (String)rtAlias);
        resultTimeQuery.createCriteria("dataset", rtDatasetAlias).add((Criterion)Restrictions.eq((String)rtDatasetId, (Object)dataset.getId())).setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)rtColumn)).add((Projection)Projections.groupProperty((String)rtDatasetId)).add((Projection)Projections.max((String)rtResultTime)));
        criteria.add(Subqueries.propertiesIn((String[])new String[]{column, dsId, "resultTime"}, (DetachedCriteria)resultTimeQuery));
        return criteria;
    }
}

