/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.bool.BooleanValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.BooleanDataEntity;
import org.n52.series.db.beans.BooleanDatasetEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.data.Data;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class BooleanDataRepository
extends AbstractDataRepository<BooleanDatasetEntity, BooleanDataEntity, BooleanValue> {
    @Override
    public Class<BooleanDatasetEntity> getDatasetEntityType() {
        return BooleanDatasetEntity.class;
    }

    @Override
    protected org.n52.io.response.dataset.Data<BooleanValue> assembleData(BooleanDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        org.n52.io.response.dataset.Data result = new org.n52.io.response.dataset.Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor((DatasetEntity)seriesEntity, query);
        for (BooleanDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.createSeriesValueFor(observation, seriesEntity, query));
        }
        return result;
    }

    @Override
    protected BooleanValue createEmptyValue() {
        return new BooleanValue();
    }

    @Override
    public BooleanValue createSeriesValueFor(BooleanDataEntity observation, BooleanDatasetEntity series, DbQuery query) {
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        Boolean observationValue = !service.isNoDataValue((Data)observation) ? (Boolean)observation.getValue() : null;
        BooleanValue value = (BooleanValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }
}

