/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.count.CountValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.CountDatasetEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.data.Data;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class CountDataRepository
extends AbstractDataRepository<CountDatasetEntity, CountDataEntity, CountValue> {
    @Override
    public Class<CountDatasetEntity> getDatasetEntityType() {
        return CountDatasetEntity.class;
    }

    @Override
    protected org.n52.io.response.dataset.Data<CountValue> assembleData(CountDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        org.n52.io.response.dataset.Data result = new org.n52.io.response.dataset.Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor((DatasetEntity)seriesEntity, query);
        for (CountDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.createSeriesValueFor(observation, seriesEntity, query));
        }
        return result;
    }

    @Override
    protected CountValue createEmptyValue() {
        return new CountValue();
    }

    @Override
    public CountValue createSeriesValueFor(CountDataEntity observation, CountDatasetEntity series, DbQuery query) {
        if (observation == null) {
            return null;
        }
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        Integer observationValue = !service.isNoDataValue((Data)observation) ? (Integer)observation.getValue() : null;
        CountValue value = (CountValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }
}

