/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.io.response.GeometryOutput;
import org.n52.io.response.GeometryType;
import org.n52.io.response.PlatformOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataModelUtil;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.PlatformRepository;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.db.dao.SamplingGeometryDao;
import org.n52.series.spi.search.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GeometriesRepository
extends SessionAwareRepository
implements OutputAssembler<GeometryOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometriesRepository.class);
    private static final String NAMED_QUERY_GET_SAMPLING_GEOMETRIES_FOR_FEATURE = "getSampleLatLonGeometries";
    private static final String NAMED_QUERY_PARAMETER_FEATURE_ID = "featureid";
    @Autowired
    private PlatformRepository platformRepository;

    private FeatureDao createFeatureDao(Session session) {
        return new FeatureDao(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            if (GeometryType.isPlatformGeometryId((String)id)) {
                String dbId = GeometryType.extractId((String)id);
                FeatureDao dao = this.createFeatureDao(session);
                boolean bl = dao.hasInstance(this.parseId(dbId), parameters);
                return bl;
            }
            if (GeometryType.isObservedGeometryId((String)id)) {
                LOGGER.warn("ObservedGeometries not fully supported right now!");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeometryOutput> getAllCondensed(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<GeometryOutput> list = this.getAllCondensed(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<GeometryOutput> getAllCondensed(DbQuery parameters, Session session) throws DataAccessException {
        return this.getAllInstances(parameters, session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeometryOutput> getAllExpanded(DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            List<GeometryOutput> list = this.getAllExpanded(parameters, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<GeometryOutput> getAllExpanded(DbQuery parameters, Session session) throws DataAccessException {
        return this.getAllInstances(parameters, session, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeometryOutput getInstance(String id, DbQuery parameters) throws DataAccessException {
        Session session = this.getSession();
        try {
            GeometryOutput geometryOutput = this.getInstance(id, parameters, session);
            return geometryOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public GeometryOutput getInstance(String id, DbQuery parameters, Session session) throws DataAccessException {
        if (GeometryType.isPlatformGeometryId((String)id)) {
            return this.getPlatformLocationGeometry(id, parameters, session);
        }
        return null;
    }

    @Override
    public Collection<SearchResult> searchFor(IoParameters parameters) {
        return Collections.emptyList();
    }

    private List<GeometryOutput> getAllInstances(DbQuery query, Session session, boolean expanded) throws DataAccessException {
        ArrayList<GeometryOutput> geometries = new ArrayList<GeometryOutput>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.shallIncludeInsituPlatformTypes()) {
            if (filterResolver.shallIncludePlatformGeometriesSite()) {
                geometries.addAll(this.getAllSites(query, session, expanded));
            }
            if (filterResolver.shallIncludePlatformGeometriesTrack()) {
                geometries.addAll(this.getAllTracks(query, session, expanded));
            }
        }
        if (filterResolver.shallIncludeRemotePlatformTypes()) {
            if (filterResolver.shallIncludeObservedGeometriesStatic()) {
                geometries.addAll(this.getAllObservedGeometriesStatic(query, session, expanded));
            }
            if (filterResolver.shallIncludeObservedGeometriesDynamic()) {
                geometries.addAll(this.getAllObservedGeometriesDynamic(query, session, expanded));
            }
        }
        return geometries;
    }

    private GeometryOutput getPlatformLocationGeometry(String id, DbQuery parameters, Session session) throws DataAccessException {
        String geometryId = GeometryType.extractId((String)id);
        FeatureEntity featureEntity = this.getFeatureEntity(geometryId, parameters, session);
        if (featureEntity != null) {
            if (GeometryType.isSiteId((String)id)) {
                return this.createSite(featureEntity, parameters, true);
            }
            if (GeometryType.isTrackId((String)id)) {
                return this.createTrack(featureEntity, parameters, true, session);
            }
        }
        return null;
    }

    private FeatureEntity getFeatureEntity(String id, DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao dao = this.createFeatureDao(session);
        long geometryId = Long.parseLong(GeometryType.extractId((String)id));
        return (FeatureEntity)dao.getInstance(geometryId, parameters);
    }

    private List<GeometryOutput> getAllSites(DbQuery query, Session session, boolean expanded) throws DataAccessException {
        IoParameters parameters = query.getParameters();
        ArrayList<GeometryOutput> GeometryOutputList = new ArrayList<GeometryOutput>();
        DbQuery siteQuery = this.getDbQuery(parameters.replaceWith("platformTypes", new String[]{"stationary"}));
        FeatureDao dao = this.createFeatureDao(session);
        for (FeatureEntity featureEntity : dao.getAllInstances(siteQuery)) {
            GeometryOutput GeometryOutput2 = this.createSite(featureEntity, query, expanded);
            if (GeometryOutput2 == null) continue;
            GeometryOutputList.add(GeometryOutput2);
        }
        return GeometryOutputList;
    }

    private GeometryOutput createSite(FeatureEntity entity, DbQuery query, boolean expanded) throws DataAccessException {
        GeometryOutput GeometryOutput2 = this.createGeometryOutput(GeometryType.PLATFORM_SITE, entity, query);
        return expanded ? this.addGeometry(GeometryOutput2, entity, query) : GeometryOutput2;
    }

    private Collection<GeometryOutput> getAllTracks(DbQuery query, Session session, boolean expanded) throws DataAccessException {
        ArrayList<GeometryOutput> GeometryOutputList = new ArrayList<GeometryOutput>();
        FeatureDao featureDao = this.createFeatureDao(session);
        DbQuery mobileQuery = query.replaceWith("platformTypes", "mobile");
        if (this.isFilterViaSamplingGeometries()) {
            DbQuery trackQuery = mobileQuery.removeSpatialFilter();
            for (FeatureEntity featureEntity : featureDao.getAllInstances(trackQuery)) {
                GeometryOutput track = this.createTrack(featureEntity, trackQuery, expanded, session);
                Geometry spatialFilter = query.getSpatialFilter();
                if (spatialFilter != null && !spatialFilter.intersects(track.getGeometry())) continue;
                GeometryOutputList.add(track);
            }
        } else {
            for (FeatureEntity featureEntity : featureDao.getAllInstances(mobileQuery)) {
                GeometryOutputList.add(this.createTrack(featureEntity, query, expanded, session));
            }
        }
        return GeometryOutputList;
    }

    private boolean isFilterViaSamplingGeometries() {
        return true;
    }

    private GeometryOutput createTrack(FeatureEntity entity, DbQuery query, boolean expanded, Session session) throws DataAccessException {
        GeometryOutput GeometryOutput2 = this.createGeometryOutput(GeometryType.PLATFORM_TRACK, entity, query);
        if (expanded) {
            if (entity.isSetGeometry()) {
                return this.addGeometry(GeometryOutput2, entity, query);
            }
            IoParameters parameters = query.getParameters();
            Geometry lineString = this.createTrajectory(entity, query, session);
            GeometryOutput2.setValue("geometry", (Object)lineString, parameters, arg_0 -> ((GeometryOutput)GeometryOutput2).setGeometry(arg_0));
            return GeometryOutput2;
        }
        return GeometryOutput2;
    }

    private GeometryOutput addGeometry(GeometryOutput GeometryOutput2, FeatureEntity entity, DbQuery query) {
        IoParameters parameters = query.getParameters();
        Geometry geometry = this.getGeometry(entity.getGeometryEntity(), query);
        GeometryOutput2.setValue("geometry", (Object)geometry, parameters, arg_0 -> ((GeometryOutput)GeometryOutput2).setGeometry(arg_0));
        return GeometryOutput2;
    }

    private Geometry createTrajectory(FeatureEntity featureEntity, DbQuery dbQuery, Session session) {
        String srid = dbQuery.getDatabaseSridCode();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        if (DataModelUtil.isNamedQuerySupported(NAMED_QUERY_GET_SAMPLING_GEOMETRIES_FOR_FEATURE, session)) {
            Query query = session.getNamedQuery(NAMED_QUERY_GET_SAMPLING_GEOMETRIES_FOR_FEATURE);
            query.setLong(NAMED_QUERY_PARAMETER_FEATURE_ID, featureEntity.getId().longValue());
            for (Object entity : query.list()) {
                Object[] row = (Object[])entity;
                if (row.length > 2) {
                    coordinates.add(new Coordinate(((Double)row[1]).doubleValue(), ((Double)row[2]).doubleValue()));
                    continue;
                }
                Geometry geom = (Geometry)row[1];
                coordinates.add(geom.getCoordinate());
            }
            Coordinate[] points = coordinates.toArray(new Coordinate[0]);
            return this.getCrsUtils().createLineString(points, srid);
        }
        SamplingGeometryDao dao = new SamplingGeometryDao(session);
        IoParameters parameters = dbQuery.getParameters().extendWith("features", new String[]{Long.toString(featureEntity.getId())});
        List<GeometryEntity> samplingGeometries = dao.getGeometriesOrderedByTimestamp(this.getDbQuery(parameters));
        return this.createLineString(samplingGeometries, dbQuery);
    }

    private Geometry createLineString(List<GeometryEntity> samplingGeometries, DbQuery query) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (GeometryEntity geometryEntity : samplingGeometries) {
            Point geometry = (Point)this.getGeometry(geometryEntity, query);
            coordinates.add(geometry.getCoordinate());
        }
        Coordinate[] points = coordinates.toArray(new Coordinate[0]);
        return this.getCrsUtils().createLineString(points, query.getDatabaseSridCode());
    }

    private Collection<GeometryOutput> getAllObservedGeometriesStatic(DbQuery parameters, Session session, boolean expanded) {
        LOGGER.warn("Static ObservedGeometries not yet supported!");
        return new ArrayList<GeometryOutput>();
    }

    private Collection<GeometryOutput> getAllObservedGeometriesDynamic(DbQuery parameters, Session session, boolean expanded) {
        LOGGER.warn("Dynamic ObservedGeometries not yet supported!");
        return new ArrayList<GeometryOutput>();
    }

    private List<GeometryEntity> getAllObservedGeometries(DbQuery parameters, Session session) {
        LOGGER.warn("ObservedGeometries not yet supported!");
        return null;
    }

    private GeometryOutput createGeometryOutput(GeometryType type, FeatureEntity featureEntity, DbQuery query) throws DataAccessException {
        GeometryOutput GeometryOutput2 = new GeometryOutput();
        IoParameters parameters = query.getParameters();
        String hrefBase = query.getHrefBase();
        PlatformOutput platform = this.getPlatfom(featureEntity, query);
        GeometryOutput2.setId(Long.toString(featureEntity.getId()));
        GeometryOutput2.setValue("properties", (Object)type, parameters, arg_0 -> ((GeometryOutput)GeometryOutput2).setGeometryType(arg_0));
        GeometryOutput2.setValue("properties", (Object)hrefBase, parameters, arg_0 -> ((GeometryOutput)GeometryOutput2).setHrefBase(arg_0));
        GeometryOutput2.setValue("properties", (Object)platform, parameters, arg_0 -> ((GeometryOutput)GeometryOutput2).setPlatform(arg_0));
        return GeometryOutput2;
    }

    private PlatformOutput getPlatfom(FeatureEntity entity, DbQuery parameters) throws DataAccessException {
        DbQuery platformQuery = this.getDbQuery(parameters.getParameters().extendWith("features", new String[]{String.valueOf(entity.getId())}).extendWith("platformTypes", new String[]{"all"}).removeAllOf("fields"));
        List platforms = this.platformRepository.getAllCondensed(platformQuery);
        if (platforms.size() != 1) {
            LOGGER.warn("expected unique platform (but was: #{}) for feature {}", (Object)platforms.size(), (Object)entity.getId());
        }
        return (PlatformOutput)platforms.iterator().next();
    }
}

