/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.DatasetFactoryException;
import org.n52.io.request.FilterResolver;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.PlatformType;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.DatasetRepository;
import org.n52.series.db.da.IDataRepositoryFactory;
import org.n52.series.db.da.ParameterRepository;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.FeatureDao;
import org.n52.series.db.dao.ParameterDao;
import org.n52.series.db.dao.PlatformDao;
import org.n52.series.db.dao.SearchableDao;
import org.n52.series.spi.search.PlatformSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.n52.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PlatformRepository
extends ParameterRepository<PlatformEntity, PlatformOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformRepository.class);
    private static final String FILTER_STATIONARY = "stationary";
    private static final String FILTER_MOBILE = "mobile";
    private static final String FILTER_INSITU = "insitu";
    private static final String FILTER_REMOTE = "remote";
    @Autowired
    private DatasetRepository<Data> seriesRepository;
    @Autowired
    private IDataRepositoryFactory factory;

    @Override
    protected PlatformOutput prepareEmptyParameterOutput() {
        return new PlatformOutput();
    }

    @Override
    protected SearchResult createEmptySearchResult(String id, String label, String baseUrl) {
        return new PlatformSearchResult(id, label, baseUrl);
    }

    @Override
    protected AbstractDao<PlatformEntity> createDao(Session session) {
        return this.createPlatformDao(session);
    }

    private PlatformDao createPlatformDao(Session session) {
        return new PlatformDao(session);
    }

    private FeatureDao createFeatureDao(Session session) {
        return new FeatureDao(session);
    }

    @Override
    protected SearchableDao<PlatformEntity> createSearchableDao(Session session) {
        return this.createPlatformDao(session);
    }

    PlatformOutput createCondensedPlatform(DatasetEntity dataset, DbQuery query, Session session) throws DataAccessException {
        PlatformEntity entity = this.getEntity(this.getPlatformId(dataset), query, session);
        return (PlatformOutput)this.createCondensed(entity, query, session);
    }

    PlatformOutput createCondensedPlatform(String id, DbQuery query, Session session) throws DataAccessException {
        PlatformEntity entity = this.getEntity(id, query, session);
        return (PlatformOutput)this.createCondensed(entity, query, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery query) throws DataAccessException {
        Session session = this.getSession();
        try {
            Long parsedId = this.parseId(PlatformType.extractId((String)id));
            ParameterDao dao = PlatformType.isStationaryId((String)id) ? this.createFeatureDao(session) : this.createPlatformDao(session);
            boolean bl = dao.hasInstance(parsedId, query);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public PlatformOutput getInstance(String id, DbQuery query, Session session) throws DataAccessException {
        PlatformEntity entity = this.getEntity(id, query, session);
        return this.createExpanded(entity, query, session);
    }

    PlatformEntity getEntity(String id, DbQuery parameters, Session session) throws DataAccessException {
        if (PlatformType.isStationaryId((String)id)) {
            return this.getStation(id, parameters, session);
        }
        return this.getPlatform(id, parameters, session);
    }

    @Override
    protected PlatformOutput createExpanded(PlatformEntity entity, DbQuery query, Session session) throws DataAccessException {
        Geometry geometry;
        PlatformOutput result = (PlatformOutput)this.createCondensed(entity, query, session);
        DbQuery platformQuery = this.getDbQuery(query.getParameters().extendWith("platforms", new String[]{result.getId()}).removeAllOf("platformTypes").removeAllOf("fields"));
        DbQuery datasetQuery = this.getDbQuery(platformQuery.getParameters().removeAllOf("bbox").removeAllOf("near").removeAllOf("$filter").removeAllOf("fields"));
        List<DatasetOutput<AbstractValue<?>>> datasets = this.seriesRepository.getAllCondensed(datasetQuery);
        Geometry geometry2 = geometry = entity.getGeometry() == null ? this.getLastSamplingGeometry(datasets, platformQuery, session) : entity.getGeometry();
        if (!this.matchesSpatialFilter(geometry, query)) {
            return null;
        }
        Set parameters = entity.getMappedParameters(query.getLocale());
        result.setValue("geometry", (Object)geometry, query.getParameters(), arg_0 -> ((PlatformOutput)result).setGeometry(arg_0));
        result.setValue("datasets", datasets, query.getParameters(), arg_0 -> ((PlatformOutput)result).setDatasets(arg_0));
        result.setValue("parameters", (Object)parameters, query.getParameters(), arg_0 -> ((PlatformOutput)result).setParameters(arg_0));
        return result;
    }

    private Geometry getLastSamplingGeometry(List<DatasetOutput<AbstractValue<?>>> datasets, DbQuery query, Session session) throws DataAccessException {
        DatasetEntity lastDataset = this.getLastDataset(datasets, query, session);
        try {
            DataRepository dataRepository = this.factory.create(lastDataset.getValueType());
            GeometryEntity lastKnownGeometry = dataRepository.getLastKnownGeometry(lastDataset, session, query);
            return this.isValidGeometry(lastKnownGeometry) ? lastKnownGeometry.getGeometry() : null;
        }
        catch (DatasetFactoryException e) {
            LOGGER.error("Couldn't create data repository to determing last value of dataset '{}'", (Object)lastDataset.getId());
            return null;
        }
    }

    private DatasetEntity getLastDataset(List<DatasetOutput<AbstractValue<?>>> datasets, DbQuery query, Session session) throws DataAccessException {
        DatasetEntity currentLastDataset = null;
        for (DatasetOutput<AbstractValue<?>> dataset : datasets) {
            String id = dataset.getId();
            DbQuery datasetQuery = this.getDbQuery(query.getParameters().removeAllOf("bbox").removeAllOf("near"));
            DatasetEntity entity = this.seriesRepository.getInstanceEntity(id, datasetQuery, session);
            if (currentLastDataset == null) {
                currentLastDataset = entity;
                continue;
            }
            if (!currentLastDataset.getLastValueAt().after(entity.getLastValueAt())) continue;
            currentLastDataset = entity;
        }
        return currentLastDataset;
    }

    private boolean isValidGeometry(GeometryEntity geometry) {
        return geometry != null && geometry.isSetGeometry();
    }

    private boolean matchesSpatialFilter(Geometry geometry, DbQuery query) {
        Geometry filter = query.getSpatialFilter();
        if (filter != null) {
            Geometry envelope = filter.getEnvelope();
            return envelope == null || geometry != null && envelope.contains(geometry);
        }
        return true;
    }

    private PlatformEntity getStation(String id, DbQuery query, Session session) throws DataAccessException {
        String featureId = PlatformType.extractId((String)id);
        FeatureDao featureDao = this.createFeatureDao(session);
        FeatureEntity feature = (FeatureEntity)featureDao.getInstance(Long.parseLong(featureId), query);
        if (feature == null) {
            this.throwNewResourceNotFoundException("Station", id);
        }
        return this.convertToPlatform(feature, query);
    }

    private PlatformEntity getPlatform(String id, DbQuery parameters, Session session) throws DataAccessException {
        String platformId;
        PlatformDao dao = this.createPlatformDao(session);
        PlatformEntity result = (PlatformEntity)dao.getInstance(Long.parseLong(platformId = PlatformType.extractId((String)id)), parameters);
        if (result == null) {
            this.throwNewResourceNotFoundException("Platform", id);
        }
        return result;
    }

    @Override
    protected List<PlatformEntity> getAllInstances(DbQuery query, Session session) throws DataAccessException {
        ArrayList<PlatformEntity> platforms = new ArrayList<PlatformEntity>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.shallIncludeStationaryPlatformTypes()) {
            platforms.addAll(this.getAllStationary(query, session));
        }
        if (filterResolver.shallIncludeMobilePlatformTypes()) {
            platforms.addAll(this.getAllMobile(query, session));
        }
        return platforms;
    }

    private List<PlatformEntity> getAllStationary(DbQuery query, Session session) throws DataAccessException {
        ArrayList<PlatformEntity> platforms = new ArrayList<PlatformEntity>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.shallIncludeInsituPlatformTypes()) {
            platforms.addAll(this.getAllStationaryInsitu(query, session));
        }
        if (filterResolver.shallIncludeRemotePlatformTypes()) {
            platforms.addAll(this.getAllStationaryRemote(query, session));
        }
        return platforms;
    }

    private List<PlatformEntity> getAllStationaryInsitu(DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao featureDao = this.createFeatureDao(session);
        DbQuery query = this.createPlatformFilter(parameters, FILTER_STATIONARY, FILTER_INSITU);
        return this.convertAll(featureDao.getAllInstances(query), query);
    }

    private List<PlatformEntity> getAllStationaryRemote(DbQuery parameters, Session session) throws DataAccessException {
        FeatureDao featureDao = this.createFeatureDao(session);
        DbQuery query = this.createPlatformFilter(parameters, FILTER_STATIONARY, FILTER_REMOTE);
        return this.convertAll(featureDao.getAllInstances(query), query);
    }

    private List<PlatformEntity> getAllMobile(DbQuery query, Session session) throws DataAccessException {
        ArrayList<PlatformEntity> platforms = new ArrayList<PlatformEntity>();
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.shallIncludeInsituPlatformTypes()) {
            platforms.addAll(this.getAllMobileInsitu(query, session));
        }
        if (filterResolver.shallIncludeRemotePlatformTypes()) {
            platforms.addAll(this.getAllMobileRemote(query, session));
        }
        return platforms;
    }

    private List<PlatformEntity> getAllMobileInsitu(DbQuery parameters, Session session) throws DataAccessException {
        DbQuery query = this.createPlatformFilter(parameters, FILTER_MOBILE, FILTER_INSITU);
        return this.createPlatformDao(session).getAllInstances(query);
    }

    private List<PlatformEntity> getAllMobileRemote(DbQuery parameters, Session session) throws DataAccessException {
        DbQuery query = this.createPlatformFilter(parameters, FILTER_MOBILE, FILTER_REMOTE);
        return this.createPlatformDao(session).getAllInstances(query);
    }

    private DbQuery createPlatformFilter(DbQuery parameters, String ... filterValues) {
        return this.getDbQuery(parameters.getParameters().replaceWith("platformTypes", filterValues));
    }

    private List<PlatformEntity> convertAll(List<FeatureEntity> entities, DbQuery query) {
        return entities.stream().map(it -> this.convertToPlatform((FeatureEntity)it, query)).collect(Collectors.toList());
    }

    private PlatformEntity convertToPlatform(FeatureEntity entity, DbQuery query) {
        PlatformEntity result = new PlatformEntity();
        result.setIdentifier(entity.getIdentifier());
        result.setId(entity.getId());
        result.setName(entity.getName());
        result.setParameters(entity.getParameters());
        result.setTranslations(entity.getTranslations());
        result.setDescription(entity.getDescription());
        result.setGeometry(this.getGeometry(entity.getGeometryEntity(), query));
        return result;
    }

    protected PlatformEntity getPlatformEntity(DatasetEntity dataset, DbQuery query, Session session) throws DataAccessException {
        return this.getEntity(this.getPlatformId(dataset), query, session);
    }

    private void throwNewResourceNotFoundException(String resource, String id) throws ResourceNotFoundException {
        throw new ResourceNotFoundException(resource + " with id '" + id + "' could not be found.");
    }
}

