/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetMetadata;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.QuantityDatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class QuantityDataRepository
extends AbstractDataRepository<QuantityDatasetEntity, QuantityDataEntity, QuantityValue> {
    @Override
    public Class<QuantityDatasetEntity> getDatasetEntityType() {
        return QuantityDatasetEntity.class;
    }

    @Override
    public List<ReferenceValueOutput<QuantityValue>> createReferenceValueOutputs(QuantityDatasetEntity datasetEntity, DbQuery query) {
        List referenceValues = datasetEntity.getReferenceValues();
        ArrayList<ReferenceValueOutput<QuantityValue>> outputs = new ArrayList<ReferenceValueOutput<QuantityValue>>();
        for (QuantityDatasetEntity referenceSeriesEntity : referenceValues) {
            ReferenceValueOutput refenceValueOutput = new ReferenceValueOutput();
            ProcedureEntity procedure = referenceSeriesEntity.getProcedure();
            refenceValueOutput.setLabel(procedure.getNameI18n(query.getLocale()));
            refenceValueOutput.setReferenceValueId(this.createReferenceDatasetId(query, referenceSeriesEntity));
            QuantityDataEntity lastValue = (QuantityDataEntity)referenceSeriesEntity.getLastObservation();
            refenceValueOutput.setLastValue((AbstractValue)this.createSeriesValueFor(lastValue, referenceSeriesEntity, query));
            outputs.add((ReferenceValueOutput<QuantityValue>)refenceValueOutput);
        }
        return outputs;
    }

    @Override
    protected Data<QuantityValue> assembleDataWithReferenceValues(QuantityDatasetEntity timeseries, DbQuery dbQuery, Session session) throws DataAccessException {
        Data<QuantityValue> result = this.assembleData(timeseries, dbQuery, session);
        List referenceValues = timeseries.getReferenceValues();
        if (referenceValues != null && !referenceValues.isEmpty()) {
            DatasetMetadata metadata = new DatasetMetadata();
            metadata.setReferenceValues(this.assembleReferenceSeries(referenceValues, dbQuery, session));
            result = this.assembleData(timeseries, dbQuery, (DatasetMetadata<QuantityValue>)metadata, session);
        }
        return result;
    }

    @Override
    protected Data<QuantityValue> assembleData(QuantityDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        return this.assembleData((Data<QuantityValue>)result, seriesEntity, query, session);
    }

    private Data<QuantityValue> assembleData(QuantityDatasetEntity seriesEntity, DbQuery query, DatasetMetadata<QuantityValue> metadata, Session session) throws DataAccessException {
        Data result = new Data(metadata);
        return this.assembleData((Data<QuantityValue>)result, seriesEntity, query, session);
    }

    private Data<QuantityValue> assembleData(Data<QuantityValue> result, QuantityDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor((DatasetEntity)seriesEntity, query);
        for (QuantityDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.createSeriesValueFor(observation, seriesEntity, query));
        }
        return result;
    }

    private Map<String, Data<QuantityValue>> assembleReferenceSeries(List<QuantityDatasetEntity> referenceValues, DbQuery query, Session session) throws DataAccessException {
        HashMap<String, Data<QuantityValue>> referenceSeries = new HashMap<String, Data<QuantityValue>>();
        for (QuantityDatasetEntity referenceSeriesEntity : referenceValues) {
            if (!referenceSeriesEntity.isPublished().booleanValue()) continue;
            Data<QuantityValue> referenceSeriesData = this.assembleData(referenceSeriesEntity, query, session);
            if (this.haveToExpandReferenceData(referenceSeriesData)) {
                referenceSeriesData = this.expandReferenceDataIfNecessary(referenceSeriesEntity, query, session);
            }
            referenceSeries.put(this.createReferenceDatasetId(query, referenceSeriesEntity), referenceSeriesData);
        }
        return referenceSeries;
    }

    protected String createReferenceDatasetId(DbQuery query, QuantityDatasetEntity referenceSeriesEntity) {
        String valueType = referenceSeriesEntity.getValueType();
        DatasetOutput dataset = DatasetOutput.create((String)valueType, (IoParameters)query.getParameters());
        Long id = referenceSeriesEntity.getId();
        dataset.setId(id.toString());
        String referenceDatasetId = dataset.getId();
        return referenceDatasetId.toString();
    }

    private boolean haveToExpandReferenceData(Data<QuantityValue> referenceSeriesData) {
        return referenceSeriesData.getValues().size() <= 1;
    }

    private Data<QuantityValue> expandReferenceDataIfNecessary(QuantityDatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor((DatasetEntity)seriesEntity, query);
        if (!this.hasValidEntriesWithinRequestedTimespan(observations)) {
            QuantityValue lastValue = (QuantityValue)this.getLastValue(seriesEntity, session, query);
            result.addValues((AbstractValue[])this.expandToInterval((BigDecimal)lastValue.getValue(), seriesEntity, query));
        }
        if (this.hasSingleValidReferenceValue(observations)) {
            QuantityDataEntity entity = (QuantityDataEntity)observations.get(0);
            result.addValues((AbstractValue[])this.expandToInterval((BigDecimal)entity.getValue(), seriesEntity, query));
        }
        return result;
    }

    private QuantityValue[] expandToInterval(BigDecimal value, QuantityDatasetEntity series, DbQuery query) {
        QuantityDataEntity referenceStart = new QuantityDataEntity();
        QuantityDataEntity referenceEnd = new QuantityDataEntity();
        referenceStart.setSamplingTimeEnd(query.getTimespan().getStart().toDate());
        referenceEnd.setSamplingTimeEnd(query.getTimespan().getEnd().toDate());
        referenceStart.setValue((Object)value);
        referenceEnd.setValue((Object)value);
        return new QuantityValue[]{this.createSeriesValueFor(referenceStart, series, query), this.createSeriesValueFor(referenceEnd, series, query)};
    }

    @Override
    protected QuantityValue createEmptyValue() {
        return new QuantityValue();
    }

    @Override
    public QuantityValue createSeriesValueFor(QuantityDataEntity observation, QuantityDatasetEntity dataset, DbQuery query) {
        QuantityValue value = this.createValue(observation, dataset, query);
        return this.addMetadatasIfNeeded(observation, value, dataset, query);
    }

    private QuantityValue createValue(QuantityDataEntity observation, QuantityDatasetEntity dataset, DbQuery query) {
        ServiceEntity service = this.getServiceEntity((DescribableEntity)dataset);
        BigDecimal observationValue = !service.isNoDataValue((org.n52.series.db.beans.data.Data)observation) ? this.format(observation, dataset) : null;
        return this.createValue(observationValue, observation, query);
    }

    QuantityValue createValue(BigDecimal observationValue, QuantityDataEntity observation, DbQuery query) {
        QuantityValue value = (QuantityValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return value;
    }

    private BigDecimal format(QuantityDataEntity observation, QuantityDatasetEntity series) {
        if (observation.getValue() == null) {
            return (BigDecimal)observation.getValue();
        }
        Integer scale = series.getNumberOfDecimals();
        return scale != null && scale >= 0 ? ((BigDecimal)observation.getValue()).setScale((int)scale, RoundingMode.HALF_UP) : (BigDecimal)observation.getValue();
    }
}

