/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.i18n.I18nFeatureEntity;
import org.n52.series.db.beans.i18n.I18nOfferingEntity;
import org.n52.series.db.beans.i18n.I18nPhenomenonEntity;
import org.n52.series.db.beans.i18n.I18nProcedureEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.QueryUtils;
import org.n52.series.db.dao.SearchableDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DatasetDao<T extends DatasetEntity>
extends AbstractDao<T>
implements SearchableDao<T> {
    public static final String FEATURE_PATH_ALIAS = "dsFeature";
    public static final String PROCEDURE_PATH_ALIAS = "dsProcedure";
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetDao.class);
    private final Class<T> entityType;

    public DatasetDao(Session session) {
        this(session, DatasetEntity.class);
    }

    public DatasetDao(Session session, Class<T> clazz) {
        super(session);
        this.entityType = clazz;
    }

    @Override
    public List<T> find(DbQuery query) {
        LOGGER.debug("find entities: {}", (Object)query);
        String searchTerm = "%" + query.getSearchTerm() + "%";
        Criteria criteria = this.getDefaultCriteria(query);
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)"name", (Object)searchTerm), Restrictions.ilike((String)"name", (Object)searchTerm), Restrictions.ilike((String)"name", (Object)searchTerm), Restrictions.ilike((String)"name", (Object)searchTerm)}));
        this.i18n(I18nOfferingEntity.class, criteria, query);
        this.i18n(I18nPhenomenonEntity.class, criteria, query);
        this.i18n(I18nProcedureEntity.class, criteria, query);
        this.i18n(I18nFeatureEntity.class, criteria, query);
        return criteria.list();
    }

    @Override
    public T getInstance(Long key, DbQuery query) {
        Criteria criteria = this.getDefaultCriteria(this.getDefaultAlias(), false, query);
        return (T)((DatasetEntity)criteria.add((Criterion)Restrictions.eq((String)"id", (Object)key)).uniqueResult());
    }

    @Override
    protected T getInstance(String key, DbQuery query, Class<T> clazz) {
        return (T)((DatasetEntity)super.getInstance(key, query, clazz, this.getDefaultCriteria(null, false, query, clazz)));
    }

    @Override
    public List<T> getAllInstances(DbQuery query) throws DataAccessException {
        LOGGER.debug("get all instances: {}", (Object)query);
        Criteria criteria = this.getDefaultCriteria(query);
        return query.addFilters(criteria, this.getDatasetProperty()).list();
    }

    public List<T> getInstancesWith(FeatureEntity feature, DbQuery query) {
        LOGGER.debug("get instance for feature '{}'", (Object)feature);
        Criteria criteria = this.getDefaultCriteria(query);
        String path = QueryUtils.createAssociation("feature", "id");
        return criteria.add((Criterion)Restrictions.eq((String)path, (Object)feature.getId())).list();
    }

    @Override
    protected Class<T> getEntityClass() {
        return this.entityType;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }

    @Override
    protected String getDefaultAlias() {
        return "dataset";
    }

    @Override
    public Criteria getDefaultCriteria(String alias, DbQuery query, Class<?> clazz) {
        return this.getDefaultCriteria(alias, true, query, clazz);
    }

    private Criteria getDefaultCriteria(String alias, boolean ignoreReferenceSeries, DbQuery query) {
        return this.getDefaultCriteria(alias, ignoreReferenceSeries, query, this.getEntityClass());
    }

    private Criteria getDefaultCriteria(String alias, boolean ignoreReferenceSeries, DbQuery query, Class<?> clazz) {
        Criteria criteria = super.getDefaultCriteria(alias, query, clazz);
        Criteria procCriteria = criteria.createCriteria("procedure", PROCEDURE_PATH_ALIAS);
        if (ignoreReferenceSeries) {
            procCriteria.add((Criterion)Restrictions.eq((String)"reference", (Object)Boolean.FALSE));
        }
        return criteria;
    }

    @Override
    protected Criteria addDatasetFilters(DbQuery query, Criteria criteria) {
        Criteria filter = criteria.add((Criterion)this.createPublishedDatasetFilter());
        query.addSpatialFilter(filter.createCriteria("feature", FEATURE_PATH_ALIAS, JoinType.LEFT_OUTER_JOIN));
        return criteria;
    }
}

