/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MoreRestrictions;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.spatial.criterion.SpatialRestrictions;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.n52.series.db.beans.CategoryDataEntity;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.TextDataEntity;
import org.n52.series.db.dao.JTSGeometryConverter;
import org.n52.series.db.dao.QueryUtils;
import org.n52.shetland.ogc.filter.BinaryLogicFilter;
import org.n52.shetland.ogc.filter.ComparisonFilter;
import org.n52.shetland.ogc.filter.Filter;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.Filters;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.filter.UnaryLogicFilter;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FESCriterionGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(FESCriterionGenerator.class);
    private static final String VR_PROCEDURE = "om:procedure";
    private static final String VR_FEATURE = "om:featureOfInterest";
    private static final String VR_OFFERING = "sos:offering";
    private static final String VR_PHENOMENON = "om:observedProperty";
    private static final String VR_VALID_TIME = "om:validTime";
    private static final String VR_IDENTIFIER = "gml:identifier";
    private static final String VR_FEATURE_SHAPE = "om:featureOfInterest/*/sams:shape";
    private static final String VR_SAMPLING_GEOMETRY = "http://www.opengis.net/req/omxml/2.0/data/samplingGeometry";
    private static final String VR_PHENOMENON_TIME = "om:phenomenonTime";
    private static final String VR_RESULT_TIME = "om:resultTime";
    private static final String VR_RESULT = "om:result";
    private final boolean unsupportedIsTrue;
    private final boolean matchDomainIds;
    private final boolean complexParent;
    private final Criteria criteria;
    private final Set<String> aliases = new HashSet<String>();

    public FESCriterionGenerator(Criteria criteria, boolean unsupportedIsTrue, boolean matchDomainIds, boolean complexParent) {
        this.criteria = Objects.requireNonNull(criteria);
        this.unsupportedIsTrue = unsupportedIsTrue;
        this.matchDomainIds = matchDomainIds;
        this.complexParent = complexParent;
    }

    protected Criteria getCriteria() {
        return this.criteria;
    }

    protected boolean isUnsupportedIsTrue() {
        return this.unsupportedIsTrue;
    }

    protected boolean isMatchDomainIds() {
        return this.matchDomainIds;
    }

    protected boolean isComplexParent() {
        return this.complexParent;
    }

    protected String addAlias(String property) {
        Iterator subcriteria = ((CriteriaImpl)this.criteria).iterateSubcriteria();
        while (subcriteria.hasNext()) {
            CriteriaImpl.Subcriteria sc = (CriteriaImpl.Subcriteria)subcriteria.next();
            if (!sc.getPath().equals(property)) continue;
            return sc.getAlias();
        }
        String alias = "odf_" + property;
        if (!this.aliases.contains(alias)) {
            this.criteria.createAlias(property, alias);
            this.aliases.add(alias);
        }
        return alias;
    }

    public Criterion create(Filter<?> filter) {
        Filter<?> f = this.simplify(filter);
        if (f instanceof ComparisonFilter) {
            return this.createComparisonCriterion((ComparisonFilter)f);
        }
        if (f instanceof BinaryLogicFilter) {
            return this.createBinaryLogicCriterion((BinaryLogicFilter)f);
        }
        if (f instanceof UnaryLogicFilter) {
            return this.createUnaryLogicCriterion((UnaryLogicFilter)f);
        }
        if (f instanceof SpatialFilter) {
            return this.createSpatialCriterion((SpatialFilter)f);
        }
        if (f instanceof TemporalFilter) {
            return this.createTemporalCriterion((TemporalFilter)f);
        }
        if (f == null) {
            return MoreRestrictions.alwaysTrue();
        }
        return this.unsupported(filter);
    }

    private Criterion createUnaryLogicCriterion(UnaryLogicFilter filter) {
        switch (filter.getOperator()) {
            case Not: {
                Criterion criterion = this.create(filter.getFilterPredicate());
                return Restrictions.not((Criterion)criterion);
            }
        }
        return this.unsupported((Filter<?>)filter);
    }

    private Criterion createBinaryLogicCriterion(BinaryLogicFilter filter) {
        Stream<Criterion> predicates = filter.getFilterPredicates().stream().map(this::create);
        switch (filter.getOperator()) {
            case And: {
                return predicates.collect(MoreRestrictions.toConjunction());
            }
            case Or: {
                return predicates.collect(MoreRestrictions.toDisjunction());
            }
        }
        return this.unsupported((Filter<?>)filter);
    }

    private Criterion createComparisonCriterion(ComparisonFilter filter) {
        switch (filter.getValueReference()) {
            case "om:result": {
                return this.createResultCriterion(filter);
            }
            case "om:phenomenonTime": {
                return this.createPhenomenonTimeCriterion(filter);
            }
            case "om:resultTime": {
                return this.createResultTimeCriterion(filter);
            }
            case "om:procedure": {
                return this.createProcedureCriterion(filter);
            }
            case "om:featureOfInterest": {
                return this.createFeatureCriterion(filter);
            }
            case "sos:offering": {
                return this.createOfferingCriterion(filter);
            }
            case "om:observedProperty": {
                return this.createPhenomenonCriterion(filter);
            }
        }
        return this.unsupported((Filter<?>)filter);
    }

    protected Criterion createSpatialFilterCriterion(SpatialFilter filter) {
        Geometry geom = JTSGeometryConverter.convert(filter.getGeometry().toGeometry());
        return this.createSpatialFilterCriterion(filter.getOperator(), filter.getValueReference(), geom);
    }

    private Criterion createSpatialFilterCriterion(FilterConstants.SpatialOperator operator, String property, Geometry geom) {
        if (geom.isEmpty()) {
            return SpatialRestrictions.isEmpty((String)property);
        }
        switch (operator) {
            case BBOX: {
                return SpatialRestrictions.filter((String)property, (Geometry)geom);
            }
            case Contains: {
                return SpatialRestrictions.contains((String)property, (Geometry)geom);
            }
            case Crosses: {
                return SpatialRestrictions.crosses((String)property, (Geometry)geom);
            }
            case Disjoint: {
                return SpatialRestrictions.disjoint((String)property, (Geometry)geom);
            }
            case Equals: {
                return SpatialRestrictions.eq((String)property, (Geometry)geom);
            }
            case Intersects: {
                return SpatialRestrictions.intersects((String)property, (Geometry)geom);
            }
            case Overlaps: {
                return SpatialRestrictions.overlaps((String)property, (Geometry)geom);
            }
            case Touches: {
                return SpatialRestrictions.touches((String)property, (Geometry)geom);
            }
            case Within: {
                return SpatialRestrictions.within((String)property, (Geometry)geom);
            }
        }
        return this.unsupported((Enum<?>)operator);
    }

    protected Criterion createComparison(ComparisonFilter filter) {
        return this.createComparison(filter, null);
    }

    protected Criterion createComparison(ComparisonFilter filter, Object value) {
        Object v = Optional.ofNullable(value).orElseGet(() -> ((ComparisonFilter)filter).getValue());
        switch (filter.getOperator()) {
            case PropertyIsEqualTo: {
                return Restrictions.eq((String)filter.getValueReference(), (Object)v);
            }
            case PropertyIsGreaterThan: {
                return Restrictions.gt((String)filter.getValueReference(), (Object)v);
            }
            case PropertyIsGreaterThanOrEqualTo: {
                return Restrictions.ge((String)filter.getValueReference(), (Object)v);
            }
            case PropertyIsLessThan: {
                return Restrictions.lt((String)filter.getValueReference(), (Object)v);
            }
            case PropertyIsLessThanOrEqualTo: {
                return Restrictions.le((String)filter.getValueReference(), (Object)v);
            }
            case PropertyIsLike: {
                if (!(v instanceof String)) {
                    throw new Error("Could not apply PropertyIsLike to non string value");
                }
                filter.setValue((String)v);
                return this.createLike(filter);
            }
            case PropertyIsNull: 
            case PropertyIsNil: {
                return Restrictions.isNull((String)filter.getValueReference());
            }
            case PropertyIsNotEqualTo: {
                return Restrictions.ne((String)filter.getValueReference(), (Object)v);
            }
        }
        return this.unsupported((Filter<?>)filter);
    }

    private Criterion createTemporalCriterion(TemporalFilter filter) {
        Time time = filter.getTime();
        if (time.isReferenced() || time.isEmpty() || this.isIndeterminate(time)) {
            return this.unsupported((Filter<?>)filter);
        }
        String valueReference = filter.getValueReference();
        FilterConstants.TimeOperator operator = filter.getOperator();
        switch (valueReference) {
            case "om:resultTime": {
                return this.createResultTimeCriterion(operator, time);
            }
            case "om:phenomenonTime": {
                return this.createPhenomenonTimeCriterion(operator, time);
            }
        }
        return this.unsupported((Filter<?>)filter);
    }

    private Criterion createTemporalCriterion(FilterConstants.TimeOperator operator, String property, Time time) {
        return this.createTemporalCriterion(operator, property, property, time);
    }

    private Criterion createTemporalCriterion(FilterConstants.TimeOperator operator, String start, String end, Time time) {
        switch (operator) {
            case TM_After: {
                return this.createAfter(time, start, end);
            }
            case TM_Before: {
                return this.createBefore(time, start, end);
            }
            case TM_Begins: {
                return this.createBegins(time, start, end);
            }
            case TM_BegunBy: {
                return this.createBegunBy(time, start, end);
            }
            case TM_Contains: {
                return this.createContains(time, start, end);
            }
            case TM_During: {
                return this.createDuring(time, start, end);
            }
            case TM_Ends: {
                return this.createEnds(time, start, end);
            }
            case TM_EndedBy: {
                return this.createEndedBy(time, start, end);
            }
            case TM_Equals: {
                return this.createEquals(time, start, end);
            }
            case TM_Meets: {
                return this.createMeets(time, end, start);
            }
            case TM_MetBy: {
                return this.createMetBy(time, start, end);
            }
            case TM_Overlaps: {
                return this.createOverlaps(time, start, end);
            }
            case TM_OverlappedBy: {
                return this.createOverlappedBy(time, start, end);
            }
        }
        return this.unsupported((Enum<?>)operator);
    }

    private Criterion createTemporalCriterion(ComparisonFilter filter, String property) {
        return this.createTemporalCriterion(filter, property, property);
    }

    private Criterion createTemporalCriterion(ComparisonFilter filter, String start, String end) {
        Time time;
        try {
            time = FESCriterionGenerator.parseTime(filter.getValue());
        }
        catch (IllegalArgumentException ex) {
            return this.unparsableTime(filter.getValue(), ex);
        }
        switch (filter.getOperator()) {
            case PropertyIsBetween: {
                Time time2;
                if (time instanceof TimePeriod) {
                    return this.unsupported((Filter<?>)filter);
                }
                try {
                    time2 = FESCriterionGenerator.parseTime(filter.getValueUpper());
                }
                catch (IllegalArgumentException ex) {
                    return this.unparsableTime(filter.getValueUpper(), ex);
                }
                if (time2 instanceof TimePeriod) {
                    return this.unsupported((Filter<?>)filter);
                }
                TimePeriod period = new TimePeriod((Object)time, (Object)time2);
                return this.createDuringEquals((Time)period, start, end);
            }
            case PropertyIsEqualTo: {
                return this.createEquals(time, start, end);
            }
            case PropertyIsGreaterThan: {
                return this.createAfter(time, start, end);
            }
            case PropertyIsGreaterThanOrEqualTo: {
                return this.createAfterEquals(time, start, end);
            }
            case PropertyIsLessThan: {
                return this.createBefore(time, start, end);
            }
            case PropertyIsLessThanOrEqualTo: {
                return this.createBeforeEquals(time, start, end);
            }
            case PropertyIsNotEqualTo: {
                return Restrictions.not((Criterion)this.createEquals(time, start, end));
            }
            case PropertyIsNil: {
                return MoreRestrictions.alwaysFalse();
            }
            case PropertyIsNull: {
                return MoreRestrictions.alwaysFalse();
            }
        }
        return this.unsupported((Filter<?>)filter);
    }

    private Filter<?> simplify(Filter<?> filter) {
        if (filter instanceof ComparisonFilter) {
            return this.simplifyComparison((ComparisonFilter)filter);
        }
        return filter;
    }

    protected Criterion unsupported(Filter<?> filter) {
        LOG.warn("Unsupported filter: {}", filter);
        return this.isUnsupportedIsTrue() ? MoreRestrictions.alwaysTrue() : MoreRestrictions.alwaysFalse();
    }

    protected Criterion unsupported(Enum<?> filter) {
        LOG.warn("Unsupported operator: {}", filter);
        return this.isUnsupportedIsTrue() ? MoreRestrictions.alwaysTrue() : MoreRestrictions.alwaysFalse();
    }

    protected Criterion unsupported(Object o) {
        LOG.warn("Unsupported: {}", o);
        return this.isUnsupportedIsTrue() ? MoreRestrictions.alwaysTrue() : MoreRestrictions.alwaysFalse();
    }

    protected Criterion unparsableTime(String value, IllegalArgumentException ex) {
        LOG.warn("Could not parse time value " + value, (Throwable)ex);
        return this.unsupported(value);
    }

    private Filter<?> simplifyComparison(ComparisonFilter filter) {
        if (filter.getOperator() == FilterConstants.ComparisonOperator.PropertyIsBetween) {
            return this.simplifyPropertyIsBetween(filter);
        }
        return filter;
    }

    private Filter<?> simplifyPropertyIsBetween(ComparisonFilter filter) {
        String valueReference = filter.getValueReference();
        String lower = filter.getValue();
        String upper = filter.getValueUpper();
        return Filters.and((Filter)Filters.ge((String)valueReference, (String)lower), (Filter)Filters.le((String)valueReference, (String)upper));
    }

    private Criterion createAfter(Time time, String start, String end) {
        DateTime dt;
        if (time instanceof TimeInstant) {
            dt = ((TimeInstant)time).getValue();
        } else if (time instanceof TimePeriod) {
            dt = ((TimePeriod)time).getEnd();
        } else {
            return this.unsupported(time);
        }
        return Restrictions.gt((String)end, (Object)dt.toDate());
    }

    private Criterion createAfterEquals(Time time, String start, String end) {
        DateTime dt;
        if (time instanceof TimeInstant) {
            dt = ((TimeInstant)time).getValue();
        } else if (time instanceof TimePeriod) {
            dt = ((TimePeriod)time).getEnd();
        } else {
            return this.unsupported(time);
        }
        return Restrictions.ge((String)end, (Object)dt.toDate());
    }

    private Criterion createBefore(Time time, String start, String end) {
        DateTime dt;
        if (time instanceof TimeInstant) {
            dt = ((TimeInstant)time).getValue();
        } else if (time instanceof TimePeriod) {
            dt = ((TimePeriod)time).getStart();
        } else {
            return this.unsupported(time);
        }
        return Restrictions.lt((String)start, (Object)dt.toDate());
    }

    private Criterion createBeforeEquals(Time time, String start, String end) {
        DateTime dt;
        if (time instanceof TimeInstant) {
            dt = ((TimeInstant)time).getValue();
        } else if (time instanceof TimePeriod) {
            dt = ((TimePeriod)time).getStart();
        } else {
            return this.unsupported(time);
        }
        return Restrictions.le((String)start, (Object)dt.toDate());
    }

    private Criterion createBegins(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.eq((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.lt((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createBegunBy(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.eq((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.gt((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createContains(Time time, String start, String end) {
        if (time instanceof TimeInstant) {
            Date date = ((TimeInstant)time).getValue().toDate();
            return Restrictions.and((Criterion)Restrictions.lt((String)start, (Object)date), (Criterion)Restrictions.gt((String)end, (Object)date));
        }
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.lt((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.gt((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createContainsEquals(Time time, String start, String end) {
        if (time instanceof TimeInstant) {
            Date date = ((TimeInstant)time).getValue().toDate();
            return Restrictions.and((Criterion)Restrictions.le((String)start, (Object)date), (Criterion)Restrictions.ge((String)end, (Object)date));
        }
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.le((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.ge((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createDuring(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.gt((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.lt((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createDuringEquals(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.ge((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.le((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createEnds(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.gt((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.eq((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createEndedBy(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.lt((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.eq((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createEquals(Time time, String start, String end) {
        if (time instanceof TimeInstant) {
            Date date = ((TimeInstant)time).getValue().toDate();
            return Restrictions.and((Criterion)Restrictions.eq((String)start, (Object)date), (Criterion)Restrictions.eq((String)end, (Object)date));
        }
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.eq((String)start, (Object)period.getStart().toDate()), (Criterion)Restrictions.eq((String)end, (Object)period.getEnd().toDate()));
        }
        return this.unsupported(time);
    }

    private Criterion createMeets(Time time, String end, String start) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.eq((String)end, (Object)period.getStart().toDate()), (Criterion)Restrictions.neProperty((String)start, (String)end));
        }
        return this.unsupported(time);
    }

    private Criterion createMetBy(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion)Restrictions.eq((String)start, (Object)period.getEnd().toDate()), (Criterion)Restrictions.neProperty((String)start, (String)end));
        }
        return this.unsupported(time);
    }

    private Criterion createOverlaps(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion[])new Criterion[]{Restrictions.lt((String)start, (Object)period.getStart().toDate()), Restrictions.gt((String)end, (Object)period.getStart().toDate()), Restrictions.gt((String)end, (Object)period.getEnd().toDate())});
        }
        return this.unsupported(time);
    }

    private Criterion createOverlappedBy(Time time, String start, String end) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return Restrictions.and((Criterion[])new Criterion[]{Restrictions.gt((String)start, (Object)period.getStart().toDate()), Restrictions.lt((String)end, (Object)period.getStart().toDate()), Restrictions.gt((String)end, (Object)period.getEnd().toDate())});
        }
        return this.unsupported(time);
    }

    private boolean isIndeterminate(Time time) {
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            return period.isSetStartIndeterminateValue() || period.isSetEndIndeterminateValue();
        }
        if (time instanceof TimeInstant) {
            TimeInstant instant = (TimeInstant)time;
            return instant.isSetIndeterminateValue();
        }
        return false;
    }

    private Criterion createLike(ComparisonFilter filter) {
        String escapeString = "\\";
        String filterEscapeString = filter.getEscapeString();
        if (filter.isSetEscapeString()) {
            if (filterEscapeString.length() != 1) {
                String escapeStringRegex = "\\\\";
                filter.setValue(filter.getValue().replaceAll(escapeStringRegex, escapeString + escapeString));
                filter.setValue(filter.getValue().replaceAll(Pattern.quote(filterEscapeString), escapeString));
                filter.setEscapeString(escapeString);
            }
        } else {
            filter.setEscapeString(escapeString);
        }
        if (filter.isSetSingleChar()) {
            String underscore = "_";
            if (!filter.getSingleChar().equals(underscore)) {
                filter.setValue(filter.getValue().replaceAll(underscore, filterEscapeString + underscore));
                filter.setValue(filter.getValue().replaceAll(Pattern.quote(filter.getSingleChar()), underscore));
            }
        }
        if (filter.isSetWildCard()) {
            String stringWildcard = "%";
            if (!filter.getWildCard().equals(stringWildcard)) {
                filter.setValue(filter.getValue().replaceAll(stringWildcard, filterEscapeString + stringWildcard));
                filter.setValue(filter.getValue().replaceAll(Pattern.quote(filter.getWildCard()), stringWildcard));
            }
        }
        return MoreRestrictions.like(filter.getValueReference(), filter.getValue(), filterEscapeString, !filter.isMatchCase());
    }

    private Criterion createProcedureCriterion(ComparisonFilter filter) {
        return this.createDatasetCriterion("procedure", filter);
    }

    private Criterion createFeatureCriterion(ComparisonFilter filter) {
        return this.createDatasetCriterion("feature", filter);
    }

    private Criterion createOfferingCriterion(ComparisonFilter filter) {
        return this.createDatasetCriterion("offering", filter);
    }

    private Criterion createPhenomenonCriterion(ComparisonFilter filter) {
        return this.createDatasetCriterion("phenomenon", filter);
    }

    private Criterion createSpatialCriterion(SpatialFilter filter) {
        switch (filter.getValueReference()) {
            case "http://www.opengis.net/req/omxml/2.0/data/samplingGeometry": {
                return this.createSamplingGeometryFilter(filter);
            }
            case "om:featureOfInterest/*/sams:shape": {
                return this.createFeatureOfInterestFilter(filter);
            }
        }
        return this.unsupported((Filter<?>)filter);
    }

    private Criterion createPhenomenonTimeCriterion(ComparisonFilter filter) {
        return this.createDataCriterion(this.createTemporalCriterion(filter, "samplingTimeStart", "samplingTimeEnd"));
    }

    private Criterion createPhenomenonTimeCriterion(FilterConstants.TimeOperator operator, Time time) {
        return this.createDataCriterion(this.createTemporalCriterion(operator, "samplingTimeStart", "samplingTimeEnd", time));
    }

    protected Stream<DetachedCriteria> getResultSubqueries(ComparisonFilter filter) {
        filter.setValueReference("value");
        Optional<DetachedCriteria> count = FESCriterionGenerator.parseInt(filter.getValue()).filter(v -> filter.getOperator() != FilterConstants.ComparisonOperator.PropertyIsLike).map(lv -> DetachedCriteria.forClass(CountDataEntity.class).add(this.createComparison(filter, lv)));
        Optional<DetachedCriteria> quantity = FESCriterionGenerator.parseDouble(filter.getValue()).filter(v -> filter.getOperator() != FilterConstants.ComparisonOperator.PropertyIsLike).map(dv -> DetachedCriteria.forClass(QuantityDataEntity.class).add(this.createComparison(filter, dv)));
        Optional<DetachedCriteria> text = Optional.of(DetachedCriteria.forClass(TextDataEntity.class).add(this.createComparison(filter)));
        Optional<DetachedCriteria> category = Optional.of(DetachedCriteria.forClass(CategoryDataEntity.class).add(this.createComparison(filter)));
        List subqueries = Stream.of(count, quantity, text, category).filter(Optional::isPresent).map(Optional::get).map(q -> q.add((Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE))).collect(Collectors.toList());
        if (!this.isComplexParent()) {
            return subqueries.stream();
        }
        DetachedCriteria profile = DetachedCriteria.forClass(ProfileDataEntity.class).add((Criterion)Restrictions.eq((String)"parent", (Object)Boolean.TRUE)).add((Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)).add(subqueries.stream().map(q -> q.add((Criterion)Restrictions.eq((String)"parent", (Object)Boolean.FALSE))).map(q -> q.setProjection((Projection)Projections.property((String)"id"))).map(q -> Subqueries.propertyIn((String)"id", (DetachedCriteria)q)).collect(MoreRestrictions.toDisjunction()));
        Stream<DetachedCriteria> topLevelPrimitives = subqueries.stream().map(q -> q.add((Criterion)Restrictions.eq((String)"parent", (Object)Boolean.TRUE)));
        return Stream.concat(Stream.of(profile), topLevelPrimitives);
    }

    private Criterion createSamplingGeometryFilter(SpatialFilter filter) {
        filter.setValueReference(QueryUtils.createAssociation("geometryEntity", "geometry"));
        return this.createDataCriterion(this.createSpatialFilterCriterion(filter));
    }

    private Criterion createFeatureOfInterestFilter(SpatialFilter filter) {
        filter.setValueReference(QueryUtils.createAssociation("geometryEntity", "geometry"));
        return this.createDatasetCriterion("feature", filter);
    }

    private Criterion createResultTimeCriterion(FilterConstants.TimeOperator operator, Time time) {
        return this.createDataCriterion(this.createTemporalCriterion(operator, "resultTime", time));
    }

    private Criterion createResultTimeCriterion(ComparisonFilter filter) {
        return this.createDataCriterion(this.createTemporalCriterion(filter, "resultTime"));
    }

    protected abstract Criterion createResultCriterion(ComparisonFilter var1);

    protected abstract Criterion createDatasetCriterion(String var1, ComparisonFilter var2);

    protected abstract Criterion createDatasetCriterion(String var1, SpatialFilter var2);

    protected abstract Criterion createDataCriterion(Criterion var1);

    public static Time parseTime(String value) throws IllegalArgumentException {
        try {
            return new TimeInstant(Instant.parse((String)value));
        }
        catch (IllegalArgumentException ex1) {
            try {
                return new TimePeriod(Interval.parse((String)value));
            }
            catch (IllegalArgumentException ex2) {
                ex2.addSuppressed(ex1);
                throw ex2;
            }
        }
    }

    public static Optional<Long> parseLong(String value) {
        return Optional.ofNullable(Longs.tryParse((String)value));
    }

    public static Optional<Integer> parseInt(String value) {
        return Optional.ofNullable(Ints.tryParse((String)value));
    }

    public static Optional<Double> parseDouble(String value) {
        return Optional.ofNullable(Doubles.tryParse((String)value));
    }

    public static Optional<Boolean> parseBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return Optional.of(Boolean.TRUE);
        }
        if (value.equalsIgnoreCase("false")) {
            return Optional.of(Boolean.FALSE);
        }
        return Optional.empty();
    }
}

