/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.transform.DistinctResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.n52.io.request.FilterResolver;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.i18n.I18nPlatformEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.ParameterDao;
import org.n52.series.db.dao.QueryUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PlatformDao
extends ParameterDao<PlatformEntity, I18nPlatformEntity> {
    public PlatformDao(Session session) {
        super(session);
    }

    @Override
    public Integer getCount(DbQuery query) throws DataAccessException {
        DetachedCriteria mobile = QueryUtils.projectionOn("procedure", this.createMobileFilter(true)).setResultTransformer((ResultTransformer)DistinctResultTransformer.INSTANCE);
        DetachedCriteria stationary = QueryUtils.projectionOn("feature", this.createMobileFilter(false)).setResultTransformer((ResultTransformer)DistinctResultTransformer.INSTANCE);
        DatasetDao datasetDao = new DatasetDao(this.session);
        return (int)Long.sum(this.count(stationary, datasetDao, query), this.count(mobile, datasetDao, query));
    }

    private Long count(DetachedCriteria subquery, AbstractDao<?> dao, DbQuery query) {
        Criteria criteria = dao.getDefaultCriteria(query);
        Criteria elements = criteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)subquery));
        return (Long)elements.setProjection(Projections.rowCount()).uniqueResult();
    }

    private DetachedCriteria createMobileFilter(boolean mobile) {
        DetachedCriteria criteria = DetachedCriteria.forClass(DatasetEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"mobile", (Object)mobile));
        return criteria;
    }

    @Override
    protected String getDatasetProperty() {
        return "procedure";
    }

    @Override
    protected Class<PlatformEntity> getEntityClass() {
        return PlatformEntity.class;
    }

    @Override
    protected Class<I18nPlatformEntity> getI18NEntityClass() {
        return I18nPlatformEntity.class;
    }

    @Override
    protected DetachedCriteria addSpatialFilter(DbQuery query, DetachedCriteria criteria) {
        FilterResolver filterResolver = query.getFilterResolver();
        if (filterResolver.isSetMobileFilter()) {
            String rtAlias = "rtAlias";
            String rtDatasetId = QueryUtils.createAssociation(rtAlias, "id");
            String rtResultTime = QueryUtils.createAssociation(rtAlias, "resultTime");
            DetachedCriteria maxResultTimeByDatasetId = DetachedCriteria.forClass(DataEntity.class, (String)rtAlias);
            maxResultTimeByDatasetId.setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)rtDatasetId)).add((Projection)Projections.max((String)rtResultTime)));
            String[] matchProperties = new String[]{"id", "resultTime"};
            DetachedCriteria observationCriteria = query.addSpatialFilter(DetachedCriteria.forClass(DataEntity.class)).add(Subqueries.propertiesIn((String[])matchProperties, (DetachedCriteria)maxResultTimeByDatasetId)).createCriteria("dataset").setProjection((Projection)Projections.property((String)"id"));
            criteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)observationCriteria));
        }
        return criteria;
    }
}

