/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.List;
import org.hibernate.Session;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.bool.BooleanValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.BooleanDataEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public class BooleanDataRepository
extends AbstractDataRepository<DatasetEntity, BooleanDataEntity, BooleanValue, Boolean> {
    @Override
    protected BooleanValue createEmptyValue() {
        return new BooleanValue();
    }

    @Override
    protected Data<BooleanValue> assembleData(DatasetEntity seriesEntity, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (BooleanDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.assembleDataValue(observation, seriesEntity, query));
        }
        return result;
    }

    @Override
    public BooleanValue assembleDataValue(BooleanDataEntity observation, DatasetEntity series, DbQuery query) {
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        Boolean observationValue = !service.isNoDataValue((DataEntity)observation) ? (Boolean)observation.getValue() : null;
        BooleanValue value = (BooleanValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }
}

