/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.category.CategoryValue;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.CategoryDataEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="category", datasetEntityType=DatasetEntity.class)
public class CategoryDataRepository
extends AbstractDataRepository<DatasetEntity, CategoryDataEntity, CategoryValue, String> {
    @Override
    protected CategoryValue createEmptyValue() {
        return new CategoryValue();
    }

    @Override
    protected Data<CategoryValue> assembleData(DatasetEntity seriesEntity, DbQuery query, Session session) {
        Data result = new Data();
        DataDao dao = new DataDao(session);
        List observations = dao.getAllInstancesFor(seriesEntity, query);
        for (CategoryDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue((AbstractValue)this.assembleDataValue(observation, seriesEntity, query));
        }
        return result;
    }

    @Override
    public CategoryValue assembleDataValue(CategoryDataEntity observation, DatasetEntity series, DbQuery query) {
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        String observationValue = !service.isNoDataValue((DataEntity)observation) ? (String)observation.getValue() : null;
        CategoryValue value = this.createValue(observation, series, query, observationValue);
        return this.addMetadatasIfNeeded(observation, value, series, query);
    }

    private CategoryValue createValue(CategoryDataEntity observation, DatasetEntity series, DbQuery query, String observationValue) {
        ServiceEntity service = this.getServiceEntity((DescribableEntity)series);
        String textValue = !service.isNoDataValue((DataEntity)observation) ? (String)observation.getValue() : null;
        return this.createValue(textValue, observation, query);
    }

    CategoryValue createValue(String observationValue, CategoryDataEntity observation, DbQuery query) {
        Date timeend = observation.getSamplingTimeEnd();
        Date timestart = observation.getSamplingTimeStart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        return parameters.isShowTimeIntervals() ? new CategoryValue(Long.valueOf(start), Long.valueOf(end), observationValue) : new CategoryValue(Long.valueOf(end), observationValue);
    }
}

