/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.profile.ProfileDataItem;
import org.n52.io.response.dataset.profile.ProfileValue;
import org.n52.io.response.dataset.profile.VerticalExtentOutput;
import org.n52.io.response.dataset.profile.VerticalExtentValueOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

public abstract class ProfileDataRepository<P extends DatasetEntity, V, T>
extends AbstractDataRepository<P, ProfileDataEntity, ProfileValue<V>, Set<DataEntity<?>>> {
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_VALUE = "value";
    private static final String PARAMETER_UNIT = "unit";

    @Override
    protected ProfileDataEntity unproxy(DataEntity<?> dataEntity, Session session) {
        if (dataEntity instanceof HibernateProxy && ((HibernateProxy)dataEntity).getHibernateLazyInitializer().getSession() == null) {
            return this.unproxy((DataEntity<?>)((DataEntity)session.load(dataEntity.getClass(), (Serializable)dataEntity.getId())), session);
        }
        return (ProfileDataEntity)Hibernate.unproxy(dataEntity);
    }

    @Override
    protected ProfileValue<V> createEmptyValue() {
        return new ProfileValue();
    }

    protected boolean isVertical(Map<String, Object> parameterObject, String verticalName) {
        if (parameterObject.containsKey(PARAMETER_NAME)) {
            String value = (String)parameterObject.get(PARAMETER_NAME);
            return value.equalsIgnoreCase(verticalName);
        }
        return false;
    }

    @Override
    protected Data<ProfileValue<V>> assembleData(P datasetEntity, DbQuery query, Session session) throws DataAccessException {
        query.setComplexParent(true);
        Data result = new Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor((DatasetEntity)datasetEntity, query);
        for (ProfileDataEntity observation : observations) {
            if (observation == null) continue;
            result.addNewValue(this.assembleDataValue(observation, datasetEntity, query));
        }
        return result;
    }

    @Override
    public ProfileValue<V> assembleDataValue(ProfileDataEntity observation, P dataset, DbQuery query) {
        ProfileValue<V> profile = this.createValue(observation, (DatasetEntity)dataset, query);
        return this.addMetadatasIfNeeded(observation, profile, dataset, query);
    }

    protected ProfileValue<T> createProfileValue(ProfileDataEntity observation, DbQuery query) {
        Date timeend = observation.getSamplingTimeEnd();
        Date timestart = observation.getSamplingTimeStart();
        long end = timeend.getTime();
        long start = timestart.getTime();
        IoParameters parameters = query.getParameters();
        ProfileValue profile = parameters.isShowTimeIntervals() ? new ProfileValue(Long.valueOf(start), Long.valueOf(end), null) : new ProfileValue(Long.valueOf(end), null);
        profile.setVerticalExtent(this.createVerticalExtent(observation));
        return profile;
    }

    private VerticalExtentOutput createVerticalExtent(ProfileDataEntity observation) {
        VerticalExtentOutput verticalExtent;
        block2: {
            verticalExtent = new VerticalExtentOutput();
            verticalExtent.setUom(observation.hasVerticalUnit() ? observation.getVerticalUnit().getSymbol() : null);
            verticalExtent.setOrientation(observation.getOrientation());
            verticalExtent.setFrom(new VerticalExtentValueOutput(observation.getVerticalFromName(), this.format(observation.getVerticalFrom(), observation.getDataset())));
            verticalExtent.setTo(new VerticalExtentValueOutput(observation.getVerticalToName(), this.format(observation.getVerticalTo(), observation.getDataset())));
            Iterator iterator = observation.getValue().iterator();
            if (!iterator.hasNext()) break block2;
            DataEntity value = (DataEntity)iterator.next();
            if (value.hasVerticalFrom() && value.hasVerticalTo()) {
                verticalExtent.setInterval(true);
            } else {
                verticalExtent.setInterval(false);
            }
        }
        return verticalExtent;
    }

    protected abstract ProfileValue<V> createValue(ProfileDataEntity var1, DatasetEntity var2, DbQuery var3);

    protected <E extends DataEntity<V>> ProfileDataItem<V> assembleDataItem(E dataEntity, ProfileValue<T> profile, ProfileDataEntity observation, DbQuery query) {
        ProfileDataItem dataItem = new ProfileDataItem();
        dataItem.setValue(dataEntity.getValue());
        BigDecimal verticalTo = this.format(dataEntity.getVerticalTo(), dataEntity.getDataset());
        BigDecimal verticalFrom = this.format(dataEntity.getVerticalFrom(), dataEntity.getDataset());
        dataItem.setVertical(verticalTo);
        if (dataEntity.hasVerticalFrom()) {
            dataItem.setVerticalFrom(verticalFrom);
        }
        return dataItem;
    }

    protected <E extends DataEntity<T>> ProfileDataItem<T> assembleDataItem(E dataEntity, ProfileValue<T> profile, Set<Map<String, Object>> parameters, DatasetEntity dataset, DbQuery query) {
        ProfileDataItem dataItem = new ProfileDataItem();
        dataItem.setValue(dataEntity.getValue());
        return dataItem;
    }
}

