/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.profile.ProfileValue;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ProfileDataEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.da.ProfileDataRepository;
import org.n52.series.db.da.QuantityDataRepository;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="quantity-profile", datasetEntityType=DatasetEntity.class)
public class QuantityProfileDataRepository
extends ProfileDataRepository<DatasetEntity, BigDecimal, BigDecimal> {
    private final QuantityDataRepository quantityRepository = new QuantityDataRepository();

    @Override
    protected ProfileValue<BigDecimal> createValue(ProfileDataEntity observation, DatasetEntity datasetEntity, DbQuery query) {
        ProfileValue profile = this.createProfileValue(observation, query);
        ArrayList<Object> dataItems = new ArrayList<Object>();
        for (DataEntity dataEntity : observation.getValue()) {
            QuantityDataEntity quantityEntity = (QuantityDataEntity)dataEntity;
            QuantityValue valueItem = this.quantityRepository.createValue((BigDecimal)quantityEntity.getValue(), quantityEntity, query);
            this.addParameters((DataEntity<?>)quantityEntity, (AbstractValue<?>)valueItem, query);
            if (dataEntity.hasVerticalFrom() || dataEntity.hasVerticalTo()) {
                dataItems.add(this.assembleDataItem(quantityEntity, profile, observation, query));
                continue;
            }
            dataItems.add(this.assembleDataItem(quantityEntity, profile, valueItem.getParameters(), datasetEntity, query));
        }
        profile.setValue(dataItems);
        return profile;
    }
}

