/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.LinkedList;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.sampling.DetectionLimitOutput;
import org.n52.io.response.sampling.MeasuringProgramOutput;
import org.n52.io.response.sampling.SamplerOutput;
import org.n52.io.response.sampling.SamplingObservationOutput;
import org.n52.io.response.sampling.SamplingOutput;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.sampling.MeasuringProgramEntity;
import org.n52.series.db.beans.sampling.SamplingEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.ParameterRepository;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.SamplingDao;
import org.n52.series.db.dao.SearchableDao;
import org.n52.series.spi.search.FeatureSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;

public class SamplingRepository
extends ParameterRepository<SamplingEntity, SamplingOutput>
implements OutputAssembler<SamplingOutput> {
    @Autowired
    private DataRepositoryTypeFactory dataRepositoryFactory;

    @Override
    protected SamplingOutput prepareEmptyParameterOutput() {
        return new SamplingOutput();
    }

    @Override
    protected SearchResult createEmptySearchResult(String id, String label, String baseUrl) {
        return new FeatureSearchResult(id, label, baseUrl);
    }

    @Override
    protected AbstractDao<SamplingEntity> createDao(Session session) {
        return new SamplingDao(session);
    }

    @Override
    protected SearchableDao<SamplingEntity> createSearchableDao(Session session) {
        return new SamplingDao(session);
    }

    @Override
    protected SamplingOutput createCondensed(SamplingEntity sampling, DbQuery query, Session session) {
        IoParameters parameters = query.getParameters();
        SamplingOutput result = this.createCondensed(this.prepareEmptyParameterOutput(), (DescribableEntity)sampling, query);
        result.setValue("domainId", (Object)sampling.getIdentifier(), parameters, arg_0 -> ((SamplingOutput)result).setDomainId(arg_0));
        result.setValue("comment", (Object)(sampling.isSetDescription() ? sampling.getDescription() : ""), parameters, arg_0 -> ((SamplingOutput)result).setComment(arg_0));
        result.setValue("measuringProgram", (Object)this.getCondensedMeasuringProgram(sampling.getMeasuringProgram(), query), parameters, arg_0 -> ((SamplingOutput)result).setMeasuringProgram(arg_0));
        result.setValue("sampler", (Object)this.getCondensedSampler(sampling.getSampler(), parameters), parameters, arg_0 -> ((SamplingOutput)result).setSampler(arg_0));
        result.setValue("samplingMehtod", (Object)sampling.getSamplingMethod(), parameters, arg_0 -> ((SamplingOutput)result).setSamplingMehtod(arg_0));
        result.setValue("environmentalConditions", (Object)(sampling.isSetEnvironmentalConditions() ? sampling.getEnvironmentalConditions() : ""), parameters, arg_0 -> ((SamplingOutput)result).setEnvironmentalConditions(arg_0));
        result.setValue("samplingTimeStart", (Object)sampling.getSamplingTimeStart().getTime(), parameters, arg_0 -> ((SamplingOutput)result).setSamplingTimeStart(arg_0));
        result.setValue("samplingTimeEnd", (Object)sampling.getSamplingTimeEnd().getTime(), parameters, arg_0 -> ((SamplingOutput)result).setSamplingTimeEnd(arg_0));
        return result;
    }

    @Override
    protected SamplingOutput createExpanded(SamplingEntity sampling, DbQuery query, Session session) {
        IoParameters parameters = query.getParameters();
        SamplingOutput result = this.createCondensed(sampling, query, session);
        result.setValue("lastSamplingObservations", this.getLastSamplingObservations(sampling, query), parameters, arg_0 -> ((SamplingOutput)result).setLastSamplingObservations(arg_0));
        return result;
    }

    private MeasuringProgramOutput getCondensedMeasuringProgram(MeasuringProgramEntity entity, DbQuery query) {
        return this.createCondensed(new MeasuringProgramOutput(), (DescribableEntity)entity, query);
    }

    private SamplerOutput getCondensedSampler(String sampler, IoParameters parameters) {
        if (sampler != null) {
            SamplerOutput result = new SamplerOutput();
            result.setValue("label", (Object)sampler, parameters, arg_0 -> ((SamplerOutput)result).setLabel(arg_0));
            return result;
        }
        return null;
    }

    private List<SamplingObservationOutput> getLastSamplingObservations(SamplingEntity sampling, DbQuery query) {
        LinkedList<SamplingObservationOutput> result = new LinkedList<SamplingObservationOutput>();
        if (sampling.hasObservations()) {
            for (DataEntity o : sampling.getObservations()) {
                if (!o.getSamplingTimeEnd().equals(sampling.getSamplingTimeEnd())) continue;
                result.add(this.getLastObservation((DataEntity)Hibernate.unproxy((Object)o), query));
            }
        }
        return result;
    }

    private SamplingObservationOutput getLastObservation(DataEntity<?> o, DbQuery query) {
        SamplingObservationOutput result = new SamplingObservationOutput();
        DataRepository<DatasetEntity, ?, ?, ?> factory = this.getDataRepositoryFactory(o.getDataset());
        result.setValue(factory.assembleDataValue(o, o.getDataset(), query));
        result.setDetectionLimit(this.getDetectionLimit(o));
        result.setDataset(this.createCondensed(DatasetOutput.create((IoParameters)query.getParameters()), (DescribableEntity)o.getDataset(), query));
        result.setCategory(this.getCondensedCategory(o.getDataset().getCategory(), query));
        result.setOffering(this.getCondensedOffering(o.getDataset().getOffering(), query));
        result.setPhenomenon(this.getCondensedPhenomenon(o.getDataset().getPhenomenon(), query));
        result.setPlatfrom(this.getCondensedPlatform(o.getDataset().getPlatform(), query));
        result.setProcedure(this.getCondensedProcedure(o.getDataset().getProcedure(), query));
        return result;
    }

    private DetectionLimitOutput getDetectionLimit(DataEntity<?> o) {
        if (o.hasSamplingProfile() && o.getSamplingProfile().hasDetectionLimit()) {
            DetectionLimitOutput result = new DetectionLimitOutput();
            result.setFlag(o.getSamplingProfile().getDetectionLimit().getFlag());
            result.setDetectionLimit(o.getSamplingProfile().getDetectionLimit().getDetectionLimit());
            return result;
        }
        return null;
    }

    private DataRepository<DatasetEntity, ?, ?, ?> getDataRepositoryFactory(DatasetEntity dataset) {
        return this.dataRepositoryFactory.create(dataset.getObservationType().name(), dataset.getValueType().name(), DatasetEntity.class);
    }
}

