/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.n52.io.crs.CRSUtils;
import org.n52.io.request.IoParameters;
import org.n52.io.response.CategoryOutput;
import org.n52.io.response.FeatureOutput;
import org.n52.io.response.OfferingOutput;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.PhenomenonOutput;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.ProcedureOutput;
import org.n52.io.response.ServiceOutput;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.HibernateSessionStore;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.DbQueryFactory;
import org.n52.series.db.dao.DefaultDbQueryFactory;
import org.n52.web.exception.BadRequestException;
import org.n52.web.exception.ResourceNotFoundException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SessionAwareRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionAwareRepository.class);
    @Autowired(required=false)
    protected ServiceEntity serviceEntity;
    @Autowired
    protected DbQueryFactory dbQueryFactory;
    private final CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
    @Autowired
    private HibernateSessionStore sessionStore;

    public DbQueryFactory getDbQueryFactory() {
        return this.dbQueryFactory != null ? this.dbQueryFactory : new DefaultDbQueryFactory();
    }

    public void setDbQueryFactory(DbQueryFactory dbQueryFactory) {
        this.dbQueryFactory = dbQueryFactory;
    }

    protected DbQuery getDbQuery(IoParameters parameters) {
        return this.dbQueryFactory.createFrom(parameters);
    }

    public HibernateSessionStore getSessionStore() {
        return this.sessionStore;
    }

    public void setSessionStore(HibernateSessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    protected CRSUtils getCrsUtils() {
        return this.crsUtils;
    }

    protected Geometry getGeometry(GeometryEntity geometryEntity, DbQuery query) {
        if (geometryEntity == null) {
            return null;
        }
        String srid = query.getDatabaseSridCode();
        geometryEntity.setGeometryFactory(this.createGeometryFactory(srid));
        try {
            return this.getCrsUtils().transformOuterToInner(geometryEntity.getGeometry(), srid);
        }
        catch (FactoryException | TransformException e) {
            throw new DataAccessException("Error while creating geometry!", e);
        }
    }

    private GeometryFactory createGeometryFactory(String srsId) {
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FLOATING);
        return srsId == null ? new GeometryFactory(pm) : new GeometryFactory(pm, CRSUtils.getSrsIdFrom((String)srsId));
    }

    protected Long parseId(String id) throws BadRequestException {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Unable to parse {} to Long.", (Throwable)e);
            throw new ResourceNotFoundException("Resource with id '" + id + "' could not be found.");
        }
    }

    public void returnSession(Session session) {
        this.sessionStore.returnSession(session);
    }

    public Session getSession() {
        try {
            return this.sessionStore.getSession();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not get hibernate session.", e);
        }
    }

    protected Map<String, DatasetParameters> createTimeseriesList(List<DatasetEntity> series, DbQuery parameters) throws DataAccessException {
        HashMap<String, DatasetParameters> timeseriesOutputs = new HashMap<String, DatasetParameters>();
        for (DatasetEntity timeseries : series) {
            if (timeseries.getProcedure().isReference()) continue;
            String timeseriesId = Long.toString(timeseries.getId());
            timeseriesOutputs.put(timeseriesId, this.createTimeseriesOutput(timeseries, parameters));
        }
        return timeseriesOutputs;
    }

    protected DatasetParameters createTimeseriesOutput(DatasetEntity dataset, DbQuery parameters) throws DataAccessException {
        DatasetParameters metadata = new DatasetParameters();
        ServiceEntity service = this.getServiceEntity((DescribableEntity)dataset);
        metadata.setService((ParameterOutput)this.getCondensedService(service, parameters));
        metadata.setOffering((ParameterOutput)this.getCondensedOffering(dataset.getOffering(), parameters));
        metadata.setProcedure((ParameterOutput)this.getCondensedProcedure(dataset.getProcedure(), parameters));
        metadata.setPhenomenon((ParameterOutput)this.getCondensedPhenomenon(dataset.getPhenomenon(), parameters));
        metadata.setCategory((ParameterOutput)this.getCondensedCategory(dataset.getCategory(), parameters));
        return metadata;
    }

    protected DatasetParameters createDatasetParameters(DatasetEntity dataset, DbQuery query, Session session) throws DataAccessException {
        DatasetParameters metadata = new DatasetParameters();
        ServiceEntity service = this.getServiceEntity((DescribableEntity)dataset);
        metadata.setService((ParameterOutput)this.getCondensedExtendedService(service, query));
        metadata.setOffering((ParameterOutput)this.getCondensedExtendedOffering(dataset.getOffering(), query));
        metadata.setProcedure((ParameterOutput)this.getCondensedExtendedProcedure(dataset.getProcedure(), query));
        metadata.setPhenomenon((ParameterOutput)this.getCondensedExtendedPhenomenon(dataset.getPhenomenon(), query));
        metadata.setCategory((ParameterOutput)this.getCondensedExtendedCategory(dataset.getCategory(), query));
        metadata.setPlatform((ParameterOutput)this.getCondensedPlatform(dataset.getPlatform(), query));
        return metadata;
    }

    protected PhenomenonOutput getCondensedPhenomenon(PhenomenonEntity entity, DbQuery parameters) {
        return this.createCondensed(new PhenomenonOutput(), (DescribableEntity)entity, parameters);
    }

    protected PhenomenonOutput getCondensedExtendedPhenomenon(PhenomenonEntity entity, DbQuery parameters) {
        return this.createCondensed(new PhenomenonOutput(), (DescribableEntity)entity, parameters);
    }

    protected OfferingOutput getCondensedOffering(OfferingEntity entity, DbQuery parameters) {
        return this.createCondensed(new OfferingOutput(), (DescribableEntity)entity, parameters);
    }

    protected ServiceOutput getCondensedService(ServiceEntity entity, DbQuery query) {
        return entity != null ? this.createCondensed(new ServiceOutput(), (DescribableEntity)entity, query) : this.createCondensed(new ServiceOutput(), (DescribableEntity)this.getServiceEntity(), query);
    }

    protected OfferingOutput getCondensedExtendedOffering(OfferingEntity entity, DbQuery parameters) {
        return this.createCondensed(new OfferingOutput(), (DescribableEntity)entity, parameters);
    }

    public void setServiceEntity(ServiceEntity serviceEntity) {
        this.serviceEntity = serviceEntity;
    }

    protected ServiceEntity getServiceEntity() {
        return this.serviceEntity;
    }

    protected ServiceEntity getServiceEntity(DescribableEntity entity) {
        this.assertServiceAvailable(entity);
        return entity.getService() != null ? entity.getService() : this.serviceEntity;
    }

    protected ServiceOutput getCondensedExtendedService(ServiceEntity entity, DbQuery parameters) {
        return this.createCondensed(new ServiceOutput(), (DescribableEntity)entity, parameters);
    }

    protected <T extends ParameterOutput> T createCondensed(T result, DescribableEntity entity, DbQuery query) {
        String id = Long.toString(entity.getId());
        String label = entity.getLabelFrom(query.getLocale());
        String domainId = entity.getIdentifier();
        String hrefBase = query.getHrefBase();
        result.setId(id);
        result.setValue("domainId", (Object)domainId, query.getParameters(), arg_0 -> result.setDomainId(arg_0));
        result.setValue("label", (Object)label, query.getParameters(), arg_0 -> result.setLabel(arg_0));
        result.setValue("href", (Object)hrefBase, query.getParameters(), arg_0 -> result.setHrefBase(arg_0));
        return result;
    }

    protected ProcedureOutput getCondensedProcedure(ProcedureEntity entity, DbQuery parameters) {
        return this.createCondensed(new ProcedureOutput(), (DescribableEntity)entity, parameters);
    }

    protected ProcedureOutput getCondensedExtendedProcedure(ProcedureEntity entity, DbQuery parameters) {
        return this.createCondensed(new ProcedureOutput(), (DescribableEntity)entity, parameters);
    }

    protected FeatureOutput getCondensedFeature(AbstractFeatureEntity<?> entity, DbQuery parameters) {
        FeatureOutput result = this.createCondensed((ParameterOutput)new FeatureOutput(), (DescribableEntity)entity, parameters);
        result.setValue("geometry", (Object)this.createGeometry(entity, parameters), parameters.getParameters(), arg_0 -> ((FeatureOutput)result).setGeometry(arg_0));
        return result;
    }

    protected Geometry createGeometry(AbstractFeatureEntity<?> featureEntity, DbQuery query) {
        return featureEntity.isSetGeometry() ? this.getGeometry(featureEntity.getGeometryEntity(), query) : null;
    }

    protected PlatformOutput getCondensedPlatform(PlatformEntity entity, DbQuery parameters) {
        return this.createCondensed(new PlatformOutput(), (DescribableEntity)entity, parameters);
    }

    protected FeatureOutput getCondensedExtendedFeature(AbstractFeatureEntity<?> entity, DbQuery parameters) {
        return this.createCondensed((ParameterOutput)new FeatureOutput(), (DescribableEntity)entity, parameters);
    }

    protected CategoryOutput getCondensedCategory(CategoryEntity entity, DbQuery parameters) {
        return this.createCondensed(new CategoryOutput(), (DescribableEntity)entity, parameters);
    }

    protected CategoryOutput getCondensedExtendedCategory(CategoryEntity entity, DbQuery parameters) {
        return this.createCondensed(new CategoryOutput(), (DescribableEntity)entity, parameters);
    }

    private void assertServiceAvailable(DescribableEntity entity) throws IllegalStateException {
        if (this.serviceEntity == null && entity == null) {
            throw new IllegalStateException("No service instance available");
        }
    }
}

