/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.Date;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.spatial.criterion.SpatialFilter;
import org.hibernate.spatial.criterion.SpatialRestrictions;
import org.hibernate.sql.JoinType;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.base.AbstractInstant;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.crs.BoundingBox;
import org.n52.io.crs.CRSUtils;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataModelUtil;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.dao.DataFESCriterionGenerator;
import org.n52.series.db.dao.DatasetFESCriterionGenerator;
import org.n52.series.db.dao.FESCriterionGenerator;
import org.n52.series.db.dao.QueryUtils;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbQuery.class);
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_LOCALE = "locale";
    private static final String PROPERTY_TRANSLATIONS = "translations";
    private static final int DEFAULT_LIMIT = 10000;
    private IoParameters parameters = IoParameters.createDefaults();
    private String databaseSridCode = "EPSG:4326";

    public DbQuery(IoParameters parameters) {
        if (parameters != null) {
            this.parameters = parameters;
        }
    }

    public DbQuery removeSpatialFilter() {
        return new DbQuery(this.parameters.removeAllOf("bbox").removeAllOf("near"));
    }

    public DbQuery replaceWith(String parameter, String ... values) {
        return new DbQuery(this.parameters.replaceWith(parameter, values));
    }

    public DbQuery removeAllOf(String ... parameterNames) {
        IoParameters ioParameters = this.parameters;
        if (parameterNames != null) {
            for (String parameterName : parameterNames) {
                ioParameters = ioParameters.removeAllOf(parameterName);
            }
        }
        return new DbQuery(ioParameters);
    }

    public String getDatabaseSridCode() {
        return this.databaseSridCode;
    }

    public void setDatabaseSridCode(String databaseSridCode) {
        this.databaseSridCode = databaseSridCode;
    }

    public String getHrefBase() {
        return this.parameters.getHrefBase();
    }

    public String getLocale() {
        return this.parameters.getLocale();
    }

    public String getSearchTerm() {
        return this.parameters.getAsString("q");
    }

    public Interval getTimespan() {
        return this.parameters.getTimespan().toInterval();
    }

    public Envelope getSpatialFilter() {
        BoundingBox spatialFilter = this.parameters.getSpatialFilter();
        if (spatialFilter != null) {
            try {
                CRSUtils crsUtils = CRSUtils.createEpsgForcedXYAxisOrder();
                Point ll = (Point)crsUtils.transformInnerToOuter((Geometry)spatialFilter.getLowerLeft(), this.databaseSridCode);
                Point ur = (Point)crsUtils.transformInnerToOuter((Geometry)spatialFilter.getUpperRight(), this.databaseSridCode);
                return new Envelope(ll.getCoordinate(), ur.getCoordinate());
            }
            catch (FactoryException e) {
                LOGGER.error("Could not create transformation facilities.", (Throwable)e);
            }
            catch (TransformException e) {
                LOGGER.error("Could not perform transformation.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isExpanded() {
        return this.parameters.isExpanded();
    }

    public boolean isMatchDomainIds() {
        return this.parameters.getAsBoolean("matchDomainIds", false);
    }

    public void setComplexParent(boolean complex) {
        this.parameters = this.parameters.extendWith("internal.complex.parent", new String[]{Boolean.toString(complex)});
    }

    public boolean isComplexParent() {
        return this.parameters.getAsBoolean("internal.complex.parent", false);
    }

    public Set<String> getValueTypes() {
        return this.parameters.getValueTypes();
    }

    public boolean isSetValueTypeFilter() {
        return !this.parameters.getValueTypes().isEmpty();
    }

    public boolean checkTranslationForLocale(Criteria criteria) {
        return !criteria.add((Criterion)Restrictions.like((String)PROPERTY_LOCALE, (Object)this.getCountryCode())).list().isEmpty();
    }

    public Criteria addLocaleTo(Criteria criteria, Class<?> clazz) {
        if (this.getLocale() != null && DataModelUtil.isEntitySupported(clazz, criteria)) {
            Criteria translations = criteria.createCriteria(PROPERTY_TRANSLATIONS, JoinType.LEFT_OUTER_JOIN);
            translations.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)PROPERTY_LOCALE, (Object)this.getCountryCode()), (Criterion)Restrictions.isNull((String)PROPERTY_LOCALE)));
        }
        return criteria;
    }

    private String getCountryCode() {
        return this.getLocale().split("_")[0];
    }

    public Criteria addTimespanTo(Criteria criteria) {
        IntervalWithTimeZone timespan = this.parameters.getTimespan();
        if (timespan != null) {
            Interval interval = timespan.toInterval();
            DateTime startDate = interval.getStart();
            DateTime endDate = interval.getEnd();
            Date start = startDate.toDate();
            Date end = endDate.toDate();
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.between((String)"samplingTimeStart", (Object)start, (Object)end), (Criterion)Restrictions.between((String)"samplingTimeEnd", (Object)start, (Object)end)));
        }
        return criteria;
    }

    public Criteria addFilters(Criteria criteria, String datasetProperty) {
        this.addLimitAndOffsetFilter(criteria);
        this.addDetachedFilters(datasetProperty, criteria);
        return criteria;
    }

    public Criteria addOdataFilterForData(Criteria criteria) {
        DataFESCriterionGenerator generator = new DataFESCriterionGenerator(criteria, true, this.isMatchDomainIds(), this.isComplexParent());
        return this.addOdataFilter(generator, criteria);
    }

    public Criteria addOdataFilterForDataset(Criteria criteria) {
        DatasetFESCriterionGenerator generator = new DatasetFESCriterionGenerator(criteria, true, this.isMatchDomainIds(), this.isComplexParent());
        return this.addOdataFilter(generator, criteria);
    }

    private Criteria addOdataFilter(FESCriterionGenerator generator, Criteria criteria) {
        return this.parameters.getODataFilter().map(generator::create).map(arg_0 -> ((Criteria)criteria).add(arg_0)).orElse(criteria);
    }

    private Criteria addLimitAndOffsetFilter(Criteria criteria) {
        if (this.getParameters().containsParameter("offset")) {
            int limit = this.getParameters().containsParameter("limit") ? this.getParameters().getLimit() : 10000;
            limit = limit > 0 ? limit : 10000;
            criteria.setFirstResult(this.getParameters().getOffset() * limit);
        }
        if (this.getParameters().containsParameter("limit")) {
            criteria.setMaxResults(this.getParameters().getLimit());
        }
        return criteria;
    }

    public Criteria addDetachedFilters(String datasetName, Criteria criteria) {
        Set categories = this.parameters.getCategories();
        Set procedures = this.parameters.getProcedures();
        Set phenomena = this.parameters.getPhenomena();
        Set offerings = this.parameters.getOfferings();
        Set platforms = this.parameters.getPlatforms();
        Set features = this.parameters.getFeatures();
        Set datasets = this.parameters.getDatasets();
        Set series = this.parameters.getSeries();
        if (!(this.hasValues(platforms) || this.hasValues(phenomena) || this.hasValues(procedures) || this.hasValues(offerings) || this.hasValues(features) || this.hasValues(categories) || this.hasValues(datasets) || this.hasValues(series))) {
            return criteria;
        }
        DetachedCriteria filter = DetachedCriteria.forClass(DatasetEntity.class);
        this.addFilterRestriction(phenomena, "phenomenon", filter);
        this.addFilterRestriction(procedures, "procedure", filter);
        this.addFilterRestriction(offerings, "offering", filter);
        this.addFilterRestriction(features, "feature", filter);
        this.addFilterRestriction(categories, "category", filter);
        this.addFilterRestriction(platforms, "platform", filter);
        this.addFilterRestriction(series, filter);
        this.addFilterRestriction(datasets, filter);
        String projectionProperty = QueryUtils.createAssociation(datasetName, PROPERTY_ID);
        filter.setProjection((Projection)Property.forName((String)projectionProperty));
        String filterProperty = QueryUtils.createAssociation(datasetName, PROPERTY_ID);
        criteria.add(Subqueries.propertyIn((String)filterProperty, (DetachedCriteria)filter));
        return criteria;
    }

    private DetachedCriteria addHierarchicalFilterRestriction(Set<String> values, String entity, DetachedCriteria filter, String prefix) {
        if (this.hasValues(values)) {
            filter.createCriteria(entity, prefix + "e").createAlias(prefix + "e.parents", prefix + "p", JoinType.LEFT_OUTER_JOIN).add((Criterion)Restrictions.or((Criterion)this.createIdCriterion(values, prefix + "e"), (Criterion)Restrictions.in((String)(prefix + "p.id"), QueryUtils.parseToIds(values))));
        }
        return filter;
    }

    private DetachedCriteria addFilterRestriction(Set<String> values, DetachedCriteria filter) {
        return this.addFilterRestriction(values, null, filter);
    }

    private DetachedCriteria addFilterRestriction(Set<String> values, String entity, DetachedCriteria filter) {
        if (this.hasValues(values)) {
            Criterion restriction = this.createIdCriterion(values);
            if (entity == null || entity.isEmpty()) {
                return filter.add(restriction);
            }
            return filter.createCriteria(entity).add(restriction);
        }
        return filter;
    }

    private Criterion createIdCriterion(Set<String> values) {
        return this.createIdCriterion(values, null);
    }

    private Criterion createIdCriterion(Set<String> values, String alias) {
        return this.parameters.isMatchDomainIds() ? this.createDomainIdFilter(values, alias) : this.createIdFilter(values, alias);
    }

    private Criterion createDomainIdFilter(Set<String> filterValues, String alias) {
        String column = QueryUtils.createAssociation(alias, "identifier");
        return (Criterion)filterValues.stream().map(filter -> Restrictions.ilike((String)column, (Object)filter)).collect(Restrictions::disjunction, Junction::add, (a, b) -> b.conditions().forEach(arg_0 -> ((Disjunction)a).add(arg_0)));
    }

    private Criterion createIdFilter(Set<String> filterValues, String alias) {
        String column = QueryUtils.createAssociation(alias, PROPERTY_ID);
        return Restrictions.in((String)column, QueryUtils.parseToIds(filterValues));
    }

    private boolean hasValues(Set<String> values) {
        return values != null && !values.isEmpty();
    }

    public Criteria addResultTimeFilter(Criteria criteria) {
        if (this.parameters.shallClassifyByResultTimes()) {
            criteria.add((Criterion)this.parameters.getResultTimes().stream().map(Instant::parse).map(AbstractInstant::toDate).map(x -> Restrictions.eq((String)"resultTime", (Object)x)).collect(Restrictions::disjunction, Junction::add, (a, b) -> b.conditions().forEach(arg_0 -> ((Disjunction)a).add(arg_0))));
        }
        return criteria;
    }

    public Criteria addSpatialFilter(Criteria criteria) {
        SpatialFilter filter = this.createSpatialFilter();
        return filter != null ? criteria.add((Criterion)filter) : criteria;
    }

    public DetachedCriteria addSpatialFilter(DetachedCriteria criteria) {
        SpatialFilter filter = this.createSpatialFilter();
        return filter != null ? criteria.add((Criterion)filter) : criteria;
    }

    public SpatialFilter createSpatialFilter() {
        Envelope envelope = this.getSpatialFilter();
        if (envelope != null) {
            int databaseSrid = CRSUtils.getSrsIdFrom((String)this.databaseSridCode);
            String geometryMember = "geometryEntity.geometry";
            return SpatialRestrictions.filter((String)geometryMember, (Envelope)envelope, (int)databaseSrid);
        }
        return null;
    }

    public IoParameters getParameters() {
        return this.parameters;
    }

    public FilterResolver getFilterResolver() {
        return this.parameters.getFilterResolver();
    }

    public String toString() {
        return "DbQuery{ parameters=" + this.getParameters().toString() + "'}'";
    }

    public DbQuery withoutFieldsFilter() {
        return new DbQuery(this.parameters.removeAllOf("fields"));
    }

    public boolean expandWithNextValuesBeyondInterval() {
        return this.parameters.isExpandWithNextValuesBeyondInterval();
    }
}

