/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.SamplingGeometryEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.QueryUtils;

public class SamplingGeometryDao {
    private static final String COLUMN_TIMESTAMP = "timestamp";
    private static final String PROPERTY_DATASET = "dataset";
    private final Session session;

    public SamplingGeometryDao(Session session) {
        this.session = session;
    }

    public List<GeometryEntity> getGeometriesOrderedByTimestamp(DbQuery query) {
        Criteria criteria = this.session.createCriteria(SamplingGeometryEntity.class);
        String path = QueryUtils.createAssociation("feature", "id");
        criteria.createCriteria(PROPERTY_DATASET).add(Restrictions.in((String)path, this.getFeatureIds(query)));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.addOrder(Order.asc((String)COLUMN_TIMESTAMP));
        query.addSpatialFilter(criteria);
        return this.toGeometryEntities(criteria.list());
    }

    protected List<Long> getFeatureIds(DbQuery query) {
        return query.getParameters().getFeatures().stream().map(Long::parseLong).collect(Collectors.toList());
    }

    private List<GeometryEntity> toGeometryEntities(List<SamplingGeometryEntity> entities) {
        return entities.stream().map(e -> e.getGeometryEntity()).collect(Collectors.toList());
    }
}

