/*
 * Decompiled with CFR 0.152.
 */
package org.n52.io.extension.resulttime;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.n52.io.request.IoParameters;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.QueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResultTimeRepository
extends SessionAwareRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultTimeRepository.class);

    ResultTimeRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getExtras(String datasetId, IoParameters parameters) {
        Session session = this.getSession();
        try {
            String alias = "datasets";
            DataDao dao = new DataDao(session);
            String datasetMember = QueryUtils.createAssociation(alias, "id");
            List resultTimes = dao.getDefaultCriteria(this.getDbQuery(parameters)).add((Criterion)Restrictions.neProperty((String)"resultTime", (String)"samplingTimeEnd")).setProjection((Projection)Projections.property((String)"resultTime")).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).createCriteria("dataset", alias).add((Criterion)Restrictions.eq((String)datasetMember, (Object)Long.parseLong(datasetId))).list();
            Set<String> set = resultTimes.stream().map(i -> new DateTime(i).toString()).collect(Collectors.toSet());
            return set;
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Could not convert id '{}' to long.", (Object)datasetId, (Object)e);
        }
        finally {
            this.returnSession(session);
        }
        return Collections.emptySet();
    }
}

