/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db;

import java.util.Properties;
import java.util.TimeZone;
import org.hibernate.SessionFactory;
import org.hibernate.type.BasicType;
import org.n52.series.db.ZonalTimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.orm.hibernate5.LocalSessionFactoryBuilder;

public class SeriesLocalSessionFactoryBean
extends LocalSessionFactoryBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeriesLocalSessionFactoryBean.class);
    private static final String DEFAULT_TIMEZONE = "UTC";
    private static final String JDBC_TIME_ZONE = "jdbc.time.zone";

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder sfb) {
        Properties properties = sfb.getProperties();
        sfb.registerTypeOverride((BasicType)this.createZonalTimestampType(properties));
        return super.buildSessionFactory(sfb);
    }

    private ZonalTimestampType createZonalTimestampType(Properties properties) {
        return new ZonalTimestampType(this.createTimeZone(properties));
    }

    private TimeZone createTimeZone(Properties properties) {
        String zone = properties.containsKey(JDBC_TIME_ZONE) ? properties.getProperty(JDBC_TIME_ZONE) : DEFAULT_TIMEZONE;
        try {
            LOGGER.info("Configure timezone for JDBC layer: " + zone);
            return TimeZone.getTimeZone(zone);
        }
        catch (Throwable e) {
            LOGGER.warn("Could not configure timezone for JDBC layer: " + zone);
            return TimeZone.getTimeZone(DEFAULT_TIMEZONE);
        }
    }
}

