/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.response.PlatformOutput;
import org.n52.io.response.ServiceOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.da.DatasetRepository;
import org.n52.series.db.da.ParameterRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.PlatformDao;
import org.n52.series.db.dao.SearchableDao;
import org.n52.series.spi.search.FeatureSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;

public class PlatformRepository
extends ParameterRepository<PlatformEntity, PlatformOutput> {
    @Autowired
    private DatasetRepository<AbstractValue<?>> datasetRepository;
    @Autowired
    private DataRepositoryTypeFactory factory;

    @Override
    protected PlatformOutput prepareEmptyParameterOutput() {
        return new PlatformOutput();
    }

    @Override
    protected SearchResult createEmptySearchResult(String id, String label, String baseUrl) {
        return new FeatureSearchResult(id, label, baseUrl);
    }

    protected PlatformDao createDao(Session session) {
        return new PlatformDao(session);
    }

    @Override
    protected SearchableDao<PlatformEntity> createSearchableDao(Session session) {
        return new PlatformDao(session);
    }

    @Override
    protected PlatformOutput createExpanded(PlatformEntity entity, DbQuery query, Session session) {
        PlatformOutput result = (PlatformOutput)this.createCondensed(entity, query, session);
        ServiceOutput service = query.getHrefBase() != null ? this.getCondensedExtendedService(this.getServiceEntity((DescribableEntity)entity), query.withoutFieldsFilter()) : this.getCondensedService(this.getServiceEntity((DescribableEntity)entity), query.withoutFieldsFilter());
        result.setValue("service", (Object)service, query.getParameters(), arg_0 -> ((PlatformOutput)result).setService(arg_0));
        DbQuery platformQuery = this.getDbQuery(query.getParameters().extendWith("platforms", new String[]{result.getId()}).removeAllOf("fields"));
        DbQuery datasetQuery = this.getDbQuery(platformQuery.getParameters().removeAllOf("$filter").removeAllOf("fields"));
        List<DatasetOutput<AbstractValue<?>>> datasets = this.datasetRepository.getAllCondensed(datasetQuery);
        result.setValue("datasets", datasets, query.getParameters(), arg_0 -> ((PlatformOutput)result).setDatasets(arg_0));
        return result;
    }

    protected List<PlatformOutput> createCondensedHierarchyMembers(Set<PlatformEntity> members, DbQuery parameters, Session session) {
        return members == null ? Collections.emptyList() : members.stream().map(e -> (PlatformOutput)this.createCondensed(e, parameters, session)).collect(Collectors.toList());
    }

    public PlatformOutput createCondensedPlatform(PlatformEntity platform, DbQuery query, Session session) {
        return this.getCondensedPlatform(platform, query);
    }
}

