/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.joda.time.Interval;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataModelUtil;
import org.n52.series.db.beans.i18n.I18nMeasuringProgramEntity;
import org.n52.series.db.beans.sampling.MeasuringProgramEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.SearchableDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasuringProgramDao
extends AbstractDao<MeasuringProgramEntity>
implements SearchableDao<MeasuringProgramEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeasuringProgramDao.class);

    public MeasuringProgramDao(Session session) {
        super(session);
    }

    @Override
    public List<MeasuringProgramEntity> find(DbQuery query) {
        if (!DataModelUtil.isEntitySupported(this.getEntityClass(), this.session)) {
            return Collections.emptyList();
        }
        LOGGER.debug("find instance: {}", (Object)query);
        Criteria criteria = this.getDefaultCriteria(query);
        criteria = this.i18n(this.getI18NEntityClass(), criteria, query);
        criteria.add(Restrictions.ilike((String)"name", (Object)("%" + query.getSearchTerm() + "%")));
        return this.addFilters(criteria, query).list();
    }

    @Override
    public List<MeasuringProgramEntity> getAllInstances(DbQuery query) throws DataAccessException {
        if (!DataModelUtil.isEntitySupported(this.getEntityClass(), this.session)) {
            return Collections.emptyList();
        }
        LOGGER.debug("get all instances: {}", (Object)query);
        Criteria criteria = this.getDefaultCriteria(query);
        criteria = this.i18n(this.getI18NEntityClass(), criteria, query);
        return this.addFilters(criteria, query).list();
    }

    private Criteria addFilters(Criteria criteria, DbQuery query) {
        this.addTimespanTo(criteria, query.getParameters());
        Criteria datasetCriteria = criteria.createCriteria("datasets");
        if (query.getParameters().getSpatialFilter() != null) {
            this.addSpatialFilter(query, datasetCriteria);
        }
        return query.addFilters(datasetCriteria, this.getDatasetProperty());
    }

    public Criteria addTimespanTo(Criteria criteria, IoParameters parameters) {
        if (parameters.containsParameter("timespan")) {
            IntervalWithTimeZone timespan = parameters.getTimespan();
            Interval interval = timespan.toInterval();
            Date start = interval.getStart().toDate();
            Date end = interval.getEnd().toDate();
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.between((String)"measuringTimeStart", (Object)start, (Object)end), Restrictions.between((String)"measuringTimeEnd", (Object)start, (Object)end), Restrictions.and((Criterion)Restrictions.le((String)"measuringTimeStart", (Object)start), (Criterion)Restrictions.or((Criterion)Restrictions.ge((String)"measuringTimeEnd", (Object)end), (Criterion)Restrictions.isNull((String)"measuringTimeEnd")))}));
        }
        return criteria;
    }

    @Override
    protected Criteria getDefaultCriteria(String alias, DbQuery query, Class<?> clazz) {
        Criteria criteria = this.session.createCriteria(clazz);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria;
    }

    @Override
    protected MeasuringProgramEntity getInstance(String key, DbQuery query, Class<MeasuringProgramEntity> clazz) {
        if (!DataModelUtil.isEntitySupported(this.getEntityClass(), this.session)) {
            return null;
        }
        LOGGER.debug("get instance for '{}'. {}", (Object)key, (Object)query);
        Criteria criteria = this.session.createCriteria(clazz);
        return this.getInstance(key, query, clazz, criteria);
    }

    protected Class<I18nMeasuringProgramEntity> getI18NEntityClass() {
        return I18nMeasuringProgramEntity.class;
    }

    @Override
    protected Class<MeasuringProgramEntity> getEntityClass() {
        return MeasuringProgramEntity.class;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }
}

