/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.srv;

import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.da.EntityCounter;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.DbQueryFactory;
import org.n52.series.spi.srv.CountingMetadataService;
import org.n52.web.exception.InternalServerException;
import org.springframework.beans.factory.annotation.Autowired;

public class CountingMetadataAccessService
implements CountingMetadataService {
    private final EntityCounter counter;
    private final DbQueryFactory dbQueryFactory;

    @Autowired
    public CountingMetadataAccessService(EntityCounter counter, DbQueryFactory dbQueryFactory) {
        this.counter = counter;
        this.dbQueryFactory = dbQueryFactory;
    }

    public int getServiceCount(IoParameters parameters) {
        return 1;
    }

    public int getOfferingCount(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countOfferings(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("offering", e);
            return -1;
        }
    }

    public int getCategoryCount(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countCategories(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("category", e);
            return -1;
        }
    }

    public int getFeatureCount(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countFeatures(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("feature", e);
            return -1;
        }
    }

    public int getProcedureCount(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countProcedures(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("procedure", e);
            return -1;
        }
    }

    public int getPhenomenaCount(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countPhenomena(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("phenomena", e);
            return -1;
        }
    }

    public int getPlatformCount(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countPlatforms(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("platform", e);
            return -1;
        }
    }

    public int getDatasetCount(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countDatasets(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("dataset", e);
            return -1;
        }
    }

    public int getSamplingCounter(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countSamplings(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("samplings", e);
            return -1;
        }
    }

    public int getMeasuringProgramCounter(IoParameters parameters) {
        try {
            DbQuery query = this.dbQueryFactory.createFrom(parameters);
            return this.counter.countMeasuringPrograms(query);
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("measruing programs", e);
            return -1;
        }
    }

    @Deprecated
    public int getStationCount() {
        try {
            return this.counter.countStations();
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("station", e);
            return -1;
        }
    }

    @Deprecated
    public int getTimeseriesCount() {
        try {
            return this.counter.countTimeseries();
        }
        catch (DataAccessException e) {
            this.throwCouldNotCountEntityException("timeseries", e);
            return -1;
        }
    }

    private void throwCouldNotCountEntityException(String entity, DataAccessException e) throws InternalServerException {
        throw new InternalServerException("Could not count " + entity + " entities.", (Throwable)e);
    }
}

