/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.locationtech.jts.geom.Geometry;
import org.n52.io.request.IoParameters;
import org.n52.io.response.CategoryOutput;
import org.n52.io.response.FeatureOutput;
import org.n52.io.response.PhenomenonOutput;
import org.n52.io.response.TimeOutput;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.sampling.MeasuringProgramOutput;
import org.n52.io.response.sampling.ProducerOutput;
import org.n52.io.response.sampling.SamplingOutput;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.sampling.MeasuringProgramEntity;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.ParameterRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.MeasuringProgramDao;
import org.n52.series.db.dao.SearchableDao;
import org.n52.series.spi.search.FeatureSearchResult;
import org.n52.series.spi.search.SearchResult;

public class MeasuringProgramRepository
extends ParameterRepository<MeasuringProgramEntity, MeasuringProgramOutput>
implements OutputAssembler<MeasuringProgramOutput> {
    @Override
    protected MeasuringProgramOutput prepareEmptyParameterOutput() {
        return new MeasuringProgramOutput();
    }

    @Override
    protected SearchResult createEmptySearchResult(String id, String label, String baseUrl) {
        return new FeatureSearchResult(id, label, baseUrl);
    }

    protected MeasuringProgramDao createDao(Session session) {
        return new MeasuringProgramDao(session);
    }

    @Override
    protected SearchableDao<MeasuringProgramEntity> createSearchableDao(Session session) {
        return new MeasuringProgramDao(session);
    }

    @Override
    protected MeasuringProgramOutput createCondensed(MeasuringProgramEntity measuringProgram, DbQuery query, Session session) {
        IoParameters parameters = query.getParameters();
        MeasuringProgramOutput result = this.createCondensed(this.prepareEmptyParameterOutput(), (DescribableEntity)measuringProgram, query);
        result.setValue("orderId", (Object)measuringProgram.getIdentifier(), parameters, arg_0 -> ((MeasuringProgramOutput)result).setOrderId(arg_0));
        result.setValue("measuringProgramTimeStart", (Object)this.createTimeOutput(measuringProgram.getMeasuringTimeStart(), parameters), parameters, arg_0 -> ((MeasuringProgramOutput)result).setMeasuringProgramTimeStart(arg_0));
        result.setValue("measuringProgramTimeEnd", (Object)this.getMeasuringtimeEnd(measuringProgram, parameters), parameters, arg_0 -> ((MeasuringProgramOutput)result).setMeasuringProgramTimeEnd(arg_0));
        result.setValue("producer", (Object)this.getCondensedProducer(measuringProgram.getProducer(), parameters), parameters, arg_0 -> ((MeasuringProgramOutput)result).setProducer(arg_0));
        result.setValue("observedArea", (Object)this.getObservedArea(measuringProgram, query), parameters, arg_0 -> ((MeasuringProgramOutput)result).setObservedArea(arg_0));
        return result;
    }

    private TimeOutput getMeasuringtimeEnd(MeasuringProgramEntity measuringProgram, IoParameters parameters) {
        if (measuringProgram.isSetMeasuringTimeEnd()) {
            return this.createTimeOutput(measuringProgram.getMeasuringTimeStart(), parameters);
        }
        return null;
    }

    @Override
    protected MeasuringProgramOutput createExpanded(MeasuringProgramEntity measuringProgram, DbQuery query, Session session) {
        IoParameters parameters = query.getParameters();
        MeasuringProgramOutput result = this.createCondensed(measuringProgram, query, session);
        result.setValue("datasets", this.getDatasets(measuringProgram, query, session), parameters, arg_0 -> ((MeasuringProgramOutput)result).setDatasets(arg_0));
        result.setValue("samplings", this.getSamplings(measuringProgram, query), parameters, arg_0 -> ((MeasuringProgramOutput)result).setSamplings(arg_0));
        result.setValue("features", this.getFeatures(measuringProgram, query), parameters, arg_0 -> ((MeasuringProgramOutput)result).setFeatures(arg_0));
        result.setValue("phenomeny", this.getPhenomena(measuringProgram, query), parameters, arg_0 -> ((MeasuringProgramOutput)result).setPhenomena(arg_0));
        result.setValue("categories", this.getCategories(measuringProgram, query), parameters, arg_0 -> ((MeasuringProgramOutput)result).setCategories(arg_0));
        return result;
    }

    private List<DatasetOutput<?>> getDatasets(MeasuringProgramEntity measuringProgram, DbQuery query, Session session) {
        return measuringProgram.getDatasets() != null ? measuringProgram.getDatasets().stream().map(d -> this.createCondensed(DatasetOutput.create((IoParameters)query.getParameters()), (DescribableEntity)d, query)).collect(Collectors.toList()) : new LinkedList();
    }

    private List<SamplingOutput> getSamplings(MeasuringProgramEntity measuringProgram, DbQuery query) {
        return measuringProgram.getSamplings() != null ? measuringProgram.getSamplings().stream().map(s -> this.createCondensed(new SamplingOutput(), (DescribableEntity)s, query)).collect(Collectors.toList()) : new LinkedList<SamplingOutput>();
    }

    private List<FeatureOutput> getFeatures(MeasuringProgramEntity measuringProgram, DbQuery query) {
        return measuringProgram.getDatasets() != null ? measuringProgram.getDatasets().stream().map(d -> this.getCondensedFeature(d.getFeature(), query)).collect(Collectors.toList()) : new LinkedList<FeatureOutput>();
    }

    private List<PhenomenonOutput> getPhenomena(MeasuringProgramEntity measuringProgram, DbQuery query) {
        return measuringProgram.getDatasets() != null ? measuringProgram.getDatasets().stream().map(d -> this.getCondensedPhenomenon(d.getPhenomenon(), query)).collect(Collectors.toList()) : new LinkedList<PhenomenonOutput>();
    }

    private List<CategoryOutput> getCategories(MeasuringProgramEntity measuringProgram, DbQuery query) {
        return measuringProgram.getDatasets() != null ? measuringProgram.getDatasets().stream().map(d -> this.getCondensedCategory(d.getCategory(), query)).collect(Collectors.toList()) : new LinkedList<CategoryOutput>();
    }

    private ProducerOutput getCondensedProducer(String producer, IoParameters parameters) {
        if (producer != null) {
            ProducerOutput result = new ProducerOutput();
            result.setValue("label", (Object)producer, parameters, arg_0 -> ((ProducerOutput)result).setLabel(arg_0));
            return result;
        }
        return null;
    }

    private Geometry getObservedArea(MeasuringProgramEntity measuringProgram, DbQuery query) {
        Geometry observedArea = null;
        if (measuringProgram.hasDatasets()) {
            for (DatasetEntity dataset : measuringProgram.getDatasets()) {
                if (!dataset.isSetFeature() || !dataset.getFeature().isSetGeometry()) continue;
                Geometry featureGeometry = this.createGeometry(dataset.getFeature(), query);
                if (observedArea == null) {
                    observedArea = featureGeometry;
                    continue;
                }
                observedArea.getEnvelopeInternal().expandToInclude(featureGeometry.getEnvelopeInternal());
            }
        }
        return observedArea;
    }
}

