/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DatasetMetadata;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.io.response.dataset.quantity.QuantityValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.dataset.ValueType;
import org.n52.series.db.da.AbstractDataRepository;
import org.n52.series.db.dao.DataDao;
import org.n52.series.db.dao.DbQuery;

@DataRepositoryComponent(value="quantity", datasetEntityType=DatasetEntity.class)
public class QuantityDataRepository
extends AbstractDataRepository<DatasetEntity, QuantityDataEntity, QuantityValue, BigDecimal> {
    @Override
    protected QuantityValue createEmptyValue() {
        return new QuantityValue();
    }

    @Override
    public List<ReferenceValueOutput<QuantityValue>> getReferenceValues(DatasetEntity dataset, DbQuery query, Session session) {
        List referenceValues = dataset.getReferenceValues().stream().filter(rv -> rv != null).collect(Collectors.toList());
        ArrayList<ReferenceValueOutput<QuantityValue>> outputs = new ArrayList<ReferenceValueOutput<QuantityValue>>();
        for (DatasetEntity referenceDatasetEntity : referenceValues) {
            if (referenceDatasetEntity == null || !referenceDatasetEntity.getValueType().equals((Object)ValueType.quantity)) continue;
            ReferenceValueOutput refenceValueOutput = new ReferenceValueOutput();
            ProcedureEntity procedure = referenceDatasetEntity.getProcedure();
            refenceValueOutput.setLabel(procedure.getNameI18n(query.getLocale()));
            refenceValueOutput.setReferenceValueId(this.createReferenceDatasetId(query, referenceDatasetEntity));
            refenceValueOutput.setLastValue(this.getLastValue(referenceDatasetEntity, session, query));
            outputs.add((ReferenceValueOutput<QuantityValue>)refenceValueOutput);
        }
        return outputs;
    }

    @Override
    protected Data<QuantityValue> assembleExpandedData(Long datasetId, DbQuery query, Session session) throws DataAccessException {
        DatasetEntity dataset;
        List referenceValues;
        Data<QuantityValue> result = this.assembleData(datasetId, query, session);
        DatasetMetadata metadata = result.getMetadata();
        if (metadata == null) {
            metadata = new DatasetMetadata();
            result.setMetadata(metadata);
        }
        if ((referenceValues = (dataset = (DatasetEntity)session.get(DatasetEntity.class, (Serializable)datasetId)).getReferenceValues()) != null && !referenceValues.isEmpty()) {
            metadata.setReferenceValues(this.assembleReferenceSeries(referenceValues, query, session));
        }
        if (query.expandWithNextValuesBeyondInterval()) {
            QuantityDataEntity previousValue = (QuantityDataEntity)this.unproxy((DataEntity<?>)this.getClosestValueBeforeStart(dataset, query, session), session);
            QuantityDataEntity nextValue = (QuantityDataEntity)this.unproxy((DataEntity<?>)this.getClosestValueAfterEnd(dataset, query, session), session);
            if (previousValue != null) {
                metadata.setValueBeforeTimespan((AbstractValue)this.createValue(previousValue, dataset, query));
            }
            if (nextValue != null) {
                metadata.setValueAfterTimespan((AbstractValue)this.createValue(nextValue, dataset, query));
            }
        }
        return result;
    }

    private Map<String, Data<QuantityValue>> assembleReferenceSeries(List<DatasetEntity> referenceValues, DbQuery query, Session session) throws DataAccessException {
        HashMap<String, Data<QuantityValue>> referencedDatasets = new HashMap<String, Data<QuantityValue>>();
        for (DatasetEntity referenceDatasetEntity : referenceValues) {
            if (referenceDatasetEntity == null || !referenceDatasetEntity.isPublished().booleanValue() || !referenceDatasetEntity.getValueType().equals((Object)ValueType.quantity)) continue;
            Data<QuantityValue> referencedDatasetData = this.assembleData(referenceDatasetEntity, query, session);
            if (this.haveToExpandReferenceData(referencedDatasetData)) {
                referencedDatasetData = this.expandReferenceDataIfNecessary(referenceDatasetEntity, query, session);
            }
            referencedDatasets.put(this.createReferenceDatasetId(query, referenceDatasetEntity), referencedDatasetData);
        }
        return referencedDatasets;
    }

    protected String createReferenceDatasetId(DbQuery query, DatasetEntity referenceDataset) {
        DatasetOutput dataset = DatasetOutput.create((IoParameters)query.getParameters());
        Long id = referenceDataset.getId();
        dataset.setId(id.toString());
        return dataset.getId();
    }

    private boolean haveToExpandReferenceData(Data<QuantityValue> referencedDatasetData) {
        return referencedDatasetData.getValues().size() <= 1;
    }

    private Data<QuantityValue> expandReferenceDataIfNecessary(DatasetEntity dataset, DbQuery query, Session session) throws DataAccessException {
        Data result = new Data();
        DataDao dao = this.createDataDao(session);
        List observations = dao.getAllInstancesFor(dataset.getId(), query);
        if (!this.hasValidEntriesWithinRequestedTimespan(observations)) {
            QuantityValue lastValue = (QuantityValue)this.getLastValue(dataset, session, query);
            result.addValues((AbstractValue[])this.expandToInterval((BigDecimal)lastValue.getValue(), dataset, query));
        }
        if (this.hasSingleValidReferenceValue(observations)) {
            QuantityDataEntity entity = (QuantityDataEntity)observations.get(0);
            result.addValues((AbstractValue[])this.expandToInterval((BigDecimal)entity.getValue(), dataset, query));
        }
        return result;
    }

    @Override
    protected Data<QuantityValue> assembleData(DatasetEntity dataset, DbQuery query, Session session) {
        return this.assembleData(dataset.getId(), query, session);
    }

    @Override
    protected Data<QuantityValue> assembleData(Long dataset, DbQuery query, Session session) {
        Data result = new Data();
        this.createDataDao(session).getAllInstancesFor(dataset, query).stream().filter(Objects::nonNull).map(observation -> this.assembleDataValue((QuantityDataEntity)observation, observation.getDataset(), query)).filter(Objects::nonNull).forEachOrdered(arg_0 -> ((Data)result).addNewValue(arg_0));
        return result;
    }

    private QuantityValue[] expandToInterval(BigDecimal value, DatasetEntity dataset, DbQuery query) {
        QuantityDataEntity referenceStart = new QuantityDataEntity();
        referenceStart.setDataset(dataset);
        Date startDate = query.getTimespan().getStart().toDate();
        referenceStart.setSamplingTimeStart(startDate);
        referenceStart.setSamplingTimeEnd(startDate);
        referenceStart.setValue((Object)value);
        Date endDate = query.getTimespan().getEnd().toDate();
        QuantityDataEntity referenceEnd = new QuantityDataEntity();
        referenceEnd.setDataset(dataset);
        referenceEnd.setSamplingTimeStart(endDate);
        referenceEnd.setSamplingTimeEnd(endDate);
        referenceEnd.setValue((Object)value);
        return new QuantityValue[]{this.assembleDataValue(referenceStart, dataset, query), this.assembleDataValue(referenceEnd, dataset, query)};
    }

    @Override
    public QuantityValue assembleDataValue(QuantityDataEntity observation, DatasetEntity dataset, DbQuery query) {
        QuantityValue value = this.createValue(observation, dataset, query);
        return this.addMetadatasIfNeeded(observation, value, dataset, query);
    }

    private QuantityValue createValue(QuantityDataEntity observation, DatasetEntity dataset, DbQuery query) {
        ServiceEntity service = this.getServiceEntity((DescribableEntity)dataset);
        return !service.isNoDataValue((DataEntity)observation) ? this.createValue(this.format(observation, dataset), observation, query) : null;
    }

    QuantityValue createValue(BigDecimal observationValue, QuantityDataEntity observation, DbQuery query) {
        QuantityValue value = (QuantityValue)this.prepareValue(observation, query);
        value.setValue((Object)observationValue);
        return value;
    }

    private BigDecimal format(QuantityDataEntity observation, DatasetEntity dataset) {
        return this.format((BigDecimal)observation.getValue(), dataset.getNumberOfDecimals());
    }
}

