/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.geolatte.geom.GeometryType;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.RootEntityResultTransformer;
import org.n52.io.request.FilterResolver;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataModelUtil;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.dataset.DatasetType;
import org.n52.series.db.beans.dataset.ObservationType;
import org.n52.series.db.beans.dataset.ValueType;
import org.n52.series.db.beans.i18n.I18nEntity;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.GenericDao;
import org.n52.series.db.dao.QueryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDao<T>
implements GenericDao<T, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDao.class);
    protected final Session session;

    public AbstractDao(Session session) {
        if (session == null) {
            throw new NullPointerException("Cannot operate on a null session.");
        }
        this.session = session;
    }

    protected abstract Class<T> getEntityClass();

    protected abstract String getDatasetProperty();

    protected String getDefaultAlias() {
        return this.getDatasetProperty();
    }

    @Override
    public boolean hasInstance(String id, DbQuery query) throws DataAccessException {
        return this.getInstance(id, query) != null;
    }

    public boolean hasInstance(String id, DbQuery query, Class<?> clazz) throws DataAccessException {
        return this.getInstance(id, query) != null;
    }

    @Override
    public boolean hasInstance(Long id, DbQuery query) {
        return this.hasInstance(id, query, this.getEntityClass());
    }

    public boolean hasInstance(Long id, DbQuery query, Class<?> clazz) {
        return this.getInstance(id, query) != null;
    }

    @Override
    public T getInstance(String key, DbQuery query) throws DataAccessException {
        return this.getInstance(key, query, this.getEntityClass());
    }

    @Override
    public T getInstance(Long key, DbQuery query) throws DataAccessException {
        LOGGER.debug("get instance '{}': {}", (Object)key, (Object)query);
        return this.getInstance(Long.toString(key), query, this.getEntityClass());
    }

    protected T getInstance(String key, DbQuery query, Class<T> clazz) {
        LOGGER.debug("get instance for '{}'. {}", (Object)key, (Object)query);
        Criteria criteria = this.getDefaultCriteria(query, clazz);
        return this.getInstance(key, query, clazz, criteria);
    }

    protected T getInstance(String key, DbQuery query, Class<T> clazz, Criteria criteria) {
        Criteria instanceCriteria = query.isMatchDomainIds() ? criteria.add((Criterion)Restrictions.eq((String)"identifier", (Object)key)) : criteria.add((Criterion)Restrictions.eq((String)"id", (Object)Long.parseLong(key)));
        return clazz.cast(instanceCriteria.uniqueResult());
    }

    @Override
    public Integer getCount(DbQuery query) throws DataAccessException {
        if (!DataModelUtil.isEntitySupported(this.getEntityClass(), this.session)) {
            return 0;
        }
        Criteria criteria = this.getDefaultCriteria(query).setProjection(Projections.rowCount());
        Object result = criteria.uniqueResult();
        if (result == null) {
            String sql = DataModelUtil.getSqlString(criteria);
            LOGGER.error("Please review query: {}", (Object)sql);
            return 0;
        }
        return ((Long)result).intValue();
    }

    protected <I extends I18nEntity> Criteria i18n(Class<I> clazz, Criteria criteria, DbQuery query) {
        return this.hasTranslation(query, clazz) ? query.addLocaleTo(criteria, clazz) : criteria;
    }

    private <I extends I18nEntity> boolean hasTranslation(DbQuery parameters, Class<I> clazz) {
        Criteria i18nCriteria = this.session.createCriteria(clazz);
        return parameters.checkTranslationForLocale(i18nCriteria);
    }

    public Criteria getDefaultCriteria(DbQuery query) {
        return this.getDefaultCriteria((String)null, query);
    }

    public Criteria getDefaultCriteria(String alias, DbQuery query) {
        return this.getDefaultCriteria(alias, query, this.getEntityClass());
    }

    private Criteria getDefaultCriteria(DbQuery query, Class<?> clazz) {
        return this.getDefaultCriteria(null, query, clazz);
    }

    protected Criteria getDefaultCriteria(String alias, DbQuery query, Class<?> clazz) {
        String nonNullAlias = alias != null ? alias : this.getDefaultAlias();
        Criteria criteria = this.session.createCriteria(clazz, nonNullAlias);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        this.addDatasetFilters(query, criteria);
        this.addMobileInsituFilter(this.getDatasetProperty(), criteria, query);
        this.addDatasetTypesFilter(this.getDatasetProperty(), criteria, query);
        return criteria;
    }

    protected Criteria addDatasetFilters(DbQuery query, Criteria criteria) {
        DetachedCriteria filter = this.createDatasetSubqueryViaExplicitJoin(query);
        return criteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)filter));
    }

    private DetachedCriteria createDatasetSubqueryViaExplicitJoin(DbQuery query) {
        DetachedCriteria subquery = DetachedCriteria.forClass(DatasetEntity.class).add((Criterion)this.createPublishedDatasetFilter());
        if (this.getDatasetProperty().equalsIgnoreCase("feature")) {
            DetachedCriteria featureCriteria = this.addSpatialFilter(query, subquery);
            return featureCriteria.setProjection((Projection)Projections.property((String)"id"));
        }
        this.addSpatialFilter(query, subquery);
        return subquery.createCriteria(this.getDatasetProperty()).setProjection((Projection)Projections.property((String)"id"));
    }

    protected final Conjunction createPublishedDatasetFilter() {
        return Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"published", (Object)true), Restrictions.eq((String)"deleted", (Object)false), Restrictions.isNotNull((String)"firstValueAt"), Restrictions.isNotNull((String)"lastValueAt")});
    }

    protected DetachedCriteria addSpatialFilter(DbQuery query, DetachedCriteria criteria) {
        return query.addSpatialFilter(criteria.createCriteria("feature"));
    }

    protected Criteria addSpatialFilter(DbQuery query, Criteria criteria) {
        return query.addSpatialFilter(criteria.createCriteria("feature"));
    }

    protected Criteria addDatasetTypesFilter(String parameter, Criteria criteria, DbQuery query) {
        IoParameters parameters = query.getParameters();
        Set datasetTypes = parameters.getDatasetTypes();
        Set observationsTypes = parameters.getObservationTypes();
        Set valueTypes = parameters.getValueTypes();
        if (!(datasetTypes.isEmpty() && observationsTypes.isEmpty() && valueTypes.isEmpty())) {
            FilterResolver filterResolver = parameters.getFilterResolver();
            if (parameters.shallBehaveBackwardsCompatible() || !filterResolver.shallIncludeAllDatasetTypes()) {
                Criterion containsValueType;
                Criterion containsDatasetType = !datasetTypes.isEmpty() ? Restrictions.in((String)"datasetType", (Collection)DatasetType.convert((Set)datasetTypes)) : null;
                Criterion containsObservationType = !observationsTypes.isEmpty() ? Restrictions.in((String)"observationType", (Collection)ObservationType.convert((Set)observationsTypes)) : null;
                Criterion criterion = containsValueType = !valueTypes.isEmpty() ? Restrictions.in((String)"valueType", (Collection)ValueType.convert((Set)valueTypes)) : null;
                if (parameter == null || parameter.isEmpty()) {
                    if (containsDatasetType != null) {
                        criteria.add(containsDatasetType);
                    }
                    if (containsObservationType != null) {
                        criteria.add(containsObservationType);
                    }
                    if (containsValueType != null) {
                        criteria.add(containsValueType);
                    }
                } else {
                    ProjectionList onPkids = this.matchPropertyPkids("dataset", parameter);
                    DetachedCriteria c = DetachedCriteria.forClass(DatasetEntity.class, (String)"dataset");
                    if (containsDatasetType != null) {
                        c.add(containsDatasetType);
                    }
                    if (containsObservationType != null) {
                        c.add(containsObservationType);
                    }
                    if (containsValueType != null) {
                        c.add(containsValueType);
                    }
                    c.setProjection((Projection)onPkids);
                    criteria.add(this.matchPropertyPkids(parameter, c));
                }
            }
        }
        return criteria;
    }

    protected Criteria addMobileInsituFilter(String parameter, Criteria criteria, DbQuery query) {
        IoParameters parameters = query.getParameters();
        FilterResolver filterResolver = parameters.getFilterResolver();
        if (!filterResolver.shallIncludeAllDatasets()) {
            SimpleExpression mobileExpression = this.createMobileExpression(filterResolver);
            SimpleExpression insituExpression = this.createInsituExpression(filterResolver);
            if (parameter == null) {
                if (mobileExpression != null) {
                    criteria.add((Criterion)mobileExpression);
                }
                if (insituExpression != null) {
                    criteria.add((Criterion)insituExpression);
                }
            } else {
                DetachedCriteria c = DetachedCriteria.forClass(DatasetEntity.class);
                if (mobileExpression != null) {
                    c.add((Criterion)mobileExpression);
                }
                if (insituExpression != null) {
                    c.add((Criterion)insituExpression);
                }
                QueryUtils.setFilterProjectionOn(parameter, c);
                criteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)c));
            }
        }
        return criteria;
    }

    private SimpleExpression createMobileExpression(FilterResolver filterResolver) {
        if (filterResolver.hasMobileFilter()) {
            boolean mobile = filterResolver.isMobileFilter();
            return Restrictions.eq((String)"mobile", (Object)mobile);
        }
        return null;
    }

    private SimpleExpression createInsituExpression(FilterResolver filterResolver) {
        if (filterResolver.hasInsituFilter()) {
            boolean insitu = filterResolver.isInsituFilter();
            return Restrictions.eq((String)"insitu", (Object)insitu);
        }
        return null;
    }

    private ProjectionList matchPropertyPkids(String alias, String property) {
        String member = QueryUtils.createAssociation(alias, property);
        String association = QueryUtils.createAssociation(member, "id");
        return Projections.projectionList().add((Projection)Projections.property((String)association));
    }

    private Criterion matchPropertyPkids(String property, DetachedCriteria c) {
        return Subqueries.propertyIn((String)QueryUtils.createAssociation(property, "id"), (DetachedCriteria)c);
    }

    private GeometryType getGeometryType(String geometryType) {
        return Arrays.stream(GeometryType.values()).filter(type -> type.name().equalsIgnoreCase(geometryType)).findAny().orElse(null);
    }

    public static String toSQLString(Criteria criteria) {
        if (!(criteria instanceof CriteriaImpl)) {
            return criteria.toString();
        }
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        SharedSessionContractImplementor session = criteriaImpl.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        String entityOrClassName = criteriaImpl.getEntityOrClassName();
        CriteriaQueryTranslator translator = new CriteriaQueryTranslator(factory, criteriaImpl, entityOrClassName, "this_");
        String[] implementors = factory.getImplementors(entityOrClassName);
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)factory.getEntityPersister(implementors[0]);
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        CriteriaJoinWalker walker = new CriteriaJoinWalker(outerJoinLoadable, translator, factory, criteriaImpl, entityOrClassName, loadQueryInfluencers);
        return walker.getSQLString();
    }

    @Deprecated
    public Collection<T> get(DbQuery query) {
        Criteria c = this.session.createCriteria(this.getEntityClass(), this.getDefaultAlias()).setResultTransformer((ResultTransformer)RootEntityResultTransformer.INSTANCE);
        DetachedCriteria subquery = DetachedCriteria.forClass(this.getEntityClass());
        subquery.add((Criterion)Restrictions.eq((String)"deleted", (Object)false));
        query.addFilters(c, this.getDatasetProperty());
        return c.list();
    }
}

