/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.srv;

import java.util.List;
import org.n52.io.TvpDataCollection;
import org.n52.io.request.IoParameters;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.Data;
import org.n52.io.response.dataset.DataCollection;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.DatasetTypesMetadata;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.DatasetRepository;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.srv.DataService;
import org.n52.series.srv.AccessService;
import org.n52.web.exception.InternalServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetAccessService<V extends AbstractValue<?>>
extends AccessService<DatasetOutput<V>>
implements DataService<Data<V>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetAccessService.class);
    @Autowired
    private DataRepositoryTypeFactory dataFactory;

    public DatasetAccessService(DatasetRepository<V> repository) {
        super(repository);
    }

    public DataCollection<Data<V>> getData(IoParameters parameters) {
        try {
            TvpDataCollection dataCollection = new TvpDataCollection();
            List<DatasetTypesMetadata> datasetTypesMetadata = this.getRepository().getDatasetTypesMetadata(parameters);
            for (DatasetTypesMetadata metadata : datasetTypesMetadata) {
                Data<V> data = this.getDataFor(metadata, parameters);
                if (data == null) continue;
                dataCollection.addNewSeries(metadata.getId(), data);
            }
            return dataCollection;
        }
        catch (DataAccessException e) {
            throw new InternalServerException("Could not get series data from database.", (Throwable)e);
        }
    }

    private Data<V> getDataFor(DatasetTypesMetadata metadata, IoParameters parameters) throws DataAccessException {
        DbQuery dbQuery = this.dbQueryFactory.createFrom(parameters);
        Class<DatasetEntity> entityType = DatasetEntity.class;
        DataRepository assembler = this.dataFactory.create(metadata.getObservationType().name(), metadata.getValueType().name(), entityType);
        return assembler.getData(metadata.getId(), dbQuery);
    }

    private DatasetRepository<V> getRepository() {
        return (DatasetRepository)this.repository;
    }
}

