/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryComponent;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.dataset.ObservationType;
import org.n52.series.db.da.DataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class AnnotationBasedDataRepositoryFactory
implements DataRepositoryTypeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationBasedDataRepositoryFactory.class);
    private final Map<String, ? super DataRepository<?, ?, ?, ?>> cache = new HashMap();
    private final ApplicationContext appContext;

    @Autowired
    public AnnotationBasedDataRepositoryFactory(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    private Stream<DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?>> getAllDataAssemblers() {
        Map beansWithAnnotation = this.appContext.getBeansWithAnnotation(DataRepositoryComponent.class);
        Collection dataAssembleTypes = beansWithAnnotation.values();
        LOGGER.debug("Found following " + DataRepositoryComponent.class.getSimpleName() + ": {}", (Object)dataAssembleTypes.stream().map(it -> it.getClass().getSimpleName()).collect(Collectors.joining(", ")));
        return dataAssembleTypes.stream().filter(DataRepository.class::isInstance).map(DataRepository.class::cast);
    }

    @Override
    public boolean isKnown(String observationType, String valueType) {
        return this.hasCacheEntry(observationType, valueType) || this.getAllDataAssemblers().map(this::getDataType).filter(it -> it.equals(this.getType(observationType, valueType))).findFirst().isPresent();
    }

    private String getType(String observationType, String valueType) {
        return observationType != null && !observationType.isEmpty() && !observationType.equalsIgnoreCase(ObservationType.simple.name()) ? valueType + "-" + observationType : valueType;
    }

    private Optional<DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?>> findDataAssembler(String observationType, String valueType) {
        return this.getAllDataAssemblers().filter(it -> this.getDataType((DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?>)it).equals(this.getType(observationType, valueType))).findFirst();
    }

    @Override
    public Set<String> getKnownTypes() {
        return this.getAllDataAssemblers().map(this::getDataType).collect(Collectors.toSet());
    }

    private String getDataType(DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?> assembler) {
        return assembler.getClass().getAnnotation(DataRepositoryComponent.class).value();
    }

    @Override
    public <S extends DatasetEntity, E extends DataEntity<T>, V extends AbstractValue<?>, T> DataRepository<S, E, V, T> create(String observationType, String valueType, Class<S> entityType) {
        return this.addToCache(observationType, valueType, this.findDataAssembler(observationType, valueType).orElseThrow(this.throwException(observationType, valueType)));
    }

    private <A extends DataRepository<? extends DatasetEntity, ? extends DataEntity<?>, ? extends AbstractValue<?>, ?>> A addToCache(String observationType, String valueType, A assembler) {
        this.cache.put(this.getType(observationType, valueType), assembler);
        return assembler;
    }

    private Supplier<? extends DataAccessException> throwException(String observationType, String valueType) {
        return () -> new DataAccessException("Unknown type: " + this.getType(observationType, valueType));
    }

    @Override
    public Class<? extends DatasetEntity> getDatasetEntityType(String observationType, String valueType) {
        return this.findDataAssembler(observationType, valueType).map(Object::getClass).map(it -> it.getAnnotation(DataRepositoryComponent.class)).map(DataRepositoryComponent::datasetEntityType).get();
    }

    @Override
    public boolean hasCacheEntry(String observationType, String valueType) {
        return this.cache.containsKey(this.getType(observationType, valueType));
    }
}

