/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.n52.io.HrefHelper;
import org.n52.io.request.IoParameters;
import org.n52.io.response.ParameterOutput;
import org.n52.io.response.dataset.AbstractValue;
import org.n52.io.response.dataset.DatasetOutput;
import org.n52.io.response.dataset.DatasetParameters;
import org.n52.io.response.dataset.ReferenceValueOutput;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataRepositoryTypeFactory;
import org.n52.series.db.DatasetTypesMetadata;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.da.DataRepository;
import org.n52.series.db.da.OutputAssembler;
import org.n52.series.db.da.SessionAwareRepository;
import org.n52.series.db.dao.DatasetDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.spi.search.DatasetSearchResult;
import org.n52.series.spi.search.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetRepository<V extends AbstractValue<?>>
extends SessionAwareRepository
implements OutputAssembler<DatasetOutput<V>> {
    @Autowired
    private DataRepositoryTypeFactory dataRepositoryFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String id, DbQuery query) {
        Session session = this.getSession();
        try {
            Class<DatasetEntity> datasetEntityType = DatasetEntity.class;
            DatasetDao<DatasetEntity> dao = this.getDatasetDao(datasetEntityType, session);
            IoParameters parameters = query.getParameters();
            boolean bl = parameters.isMatchDomainIds() ? dao.hasInstance(id, query, datasetEntityType) : dao.hasInstance(this.parseId(id), query, datasetEntityType);
            return bl;
        }
        finally {
            this.returnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetOutput<V>> getAllCondensed(DbQuery query) {
        Session session = this.getSession();
        try {
            List<DatasetOutput<V>> list = this.getAllCondensed(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<DatasetOutput<V>> getAllCondensed(DbQuery query, Session session) {
        ArrayList<DatasetOutput<V>> results = new ArrayList<DatasetOutput<V>>();
        if (query.getParameters().isMatchDomainIds()) {
            Class<DatasetEntity> datasetEntityType = DatasetEntity.class;
            this.addCondensedResults(this.getDatasetDao(datasetEntityType, session), query, results, session);
            return results;
        }
        this.addCondensedResults(this.getDatasetDao(DatasetEntity.class, session), query, results, session);
        return results;
    }

    private void addCondensedResults(DatasetDao<? extends DatasetEntity> dao, DbQuery query, List<DatasetOutput<V>> results, Session session) {
        for (DatasetEntity datasetEntity : dao.getAllInstances(query)) {
            if (!this.dataRepositoryFactory.isKnown(datasetEntity.getObservationType().name(), datasetEntity.getValueType().name())) continue;
            results.add(this.createCondensed(datasetEntity, query, session));
        }
    }

    private DatasetDao<? extends DatasetEntity> getDatasetDao(Class<? extends DatasetEntity> clazz, Session session) {
        return new DatasetDao<DatasetEntity>(session, clazz);
    }

    private DatasetDao<? extends DatasetEntity> getSeriesDao(String datasetId, DbQuery query, Session session) throws DataAccessException {
        Class<DatasetEntity> datasetEntityType = DatasetEntity.class;
        return this.createDataAccessRepository(datasetEntityType, session);
    }

    private DatasetDao<? extends DatasetEntity> createDataAccessRepository(Class<? extends DatasetEntity> datasetEntityType, Session session) {
        return this.getDatasetDao(datasetEntityType, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetOutput<V>> getAllExpanded(DbQuery query) {
        Session session = this.getSession();
        try {
            List<DatasetOutput<V>> list = this.getAllExpanded(query, session);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public List<DatasetOutput<V>> getAllExpanded(DbQuery query, Session session) {
        ArrayList<DatasetOutput<V>> results = new ArrayList<DatasetOutput<V>>();
        if (query.getParameters().isMatchDomainIds()) {
            this.addExpandedResults(this.getDatasetDao(DatasetEntity.class, session), query, results, session);
            return results;
        }
        this.addExpandedResults(this.getDatasetDao(DatasetEntity.class, session), query, results, session);
        return results;
    }

    private void addExpandedResults(DatasetDao<? extends DatasetEntity> dao, DbQuery query, List<DatasetOutput<V>> results, Session session) {
        for (DatasetEntity datasetEntity : dao.getAllInstances(query)) {
            if (!this.dataRepositoryFactory.isKnown(datasetEntity.getObservationType().name(), datasetEntity.getValueType().name())) continue;
            results.add(this.createExpanded(datasetEntity, query, session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetOutput<V> getInstance(String id, DbQuery query) {
        Session session = this.getSession();
        try {
            DatasetOutput<V> datasetOutput = this.getInstance(id, query, session);
            return datasetOutput;
        }
        finally {
            this.returnSession(session);
        }
    }

    @Override
    public DatasetOutput<V> getInstance(String id, DbQuery query, Session session) {
        DatasetEntity instanceEntity = this.getInstanceEntity(id, query, session);
        return this.createExpanded(instanceEntity, query, session);
    }

    DatasetEntity getInstanceEntity(String id, DbQuery query, Session session) {
        DatasetDao<DatasetEntity> dao = this.getDatasetDao(DatasetEntity.class, session);
        DatasetEntity instance = dao.getInstance(Long.parseLong(id), query);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SearchResult> searchFor(IoParameters paramters) {
        Session session = this.getSession();
        try {
            DatasetDao<DatasetEntity> dao = this.getDatasetDao(DatasetEntity.class, session);
            DbQuery query = this.getDbQuery(paramters);
            List<DatasetEntity> found = dao.find(query);
            List<SearchResult> list = this.convertToSearchResults(found, query);
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }

    public List<SearchResult> convertToSearchResults(List<? extends DescribableEntity> found, DbQuery query) {
        String locale = query.getLocale();
        String hrefBase = query.getHrefBase();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (DescribableEntity describableEntity : found) {
            String id = describableEntity.getId().toString();
            String label = describableEntity.getLabelFrom(locale);
            results.add((SearchResult)new DatasetSearchResult(id, label, hrefBase));
        }
        return results;
    }

    protected DatasetOutput<V> createCondensed(DatasetEntity dataset, DbQuery query, Session session) {
        IoParameters parameters = query.getParameters();
        if (dataset.getService() == null) {
            dataset.setService(this.getServiceEntity());
        }
        DatasetOutput result = DatasetOutput.create((IoParameters)parameters);
        Long id = dataset.getId();
        String hrefBase = query.getHrefBase();
        String domainId = dataset.getIdentifier();
        String uom = dataset.getUnitI18nName(query.getLocale());
        String label = this.createDatasetLabel(dataset, query.getLocale());
        result.setId(id.toString());
        result.setValue("uom", (Object)uom, parameters, arg_0 -> ((DatasetOutput)result).setUom(arg_0));
        result.setValue("label", (Object)label, parameters, arg_0 -> ((DatasetOutput)result).setLabel(arg_0));
        result.setValue("domainId", (Object)domainId, parameters, arg_0 -> ((DatasetOutput)result).setDomainId(arg_0));
        result.setValue("datasetType", (Object)dataset.getDatasetType().name(), parameters, arg_0 -> ((DatasetOutput)result).setDatasetType(arg_0));
        result.setValue("observationType", (Object)dataset.getObservationType().name(), parameters, arg_0 -> ((DatasetOutput)result).setObservationType(arg_0));
        result.setValue("valueType", (Object)dataset.getValueType().name(), parameters, arg_0 -> ((DatasetOutput)result).setValueType(arg_0));
        result.setValue("mobile", (Object)dataset.isMobile(), parameters, arg_0 -> ((DatasetOutput)result).setMobile(arg_0));
        result.setValue("insitu", (Object)dataset.isInsitu(), parameters, arg_0 -> ((DatasetOutput)result).setInsitu(arg_0));
        result.setValue("href", (Object)this.createHref(hrefBase, dataset), parameters, arg_0 -> ((DatasetOutput)result).setHref(arg_0));
        result.setValue("originTimezone", (Object)(dataset.isSetOriginTimezone() ? dataset.getOriginTimezone() : "UTC"), parameters, arg_0 -> ((DatasetOutput)result).setOriginTimezone(arg_0));
        result.setValue("samplingTimeStart", (Object)this.createTimeOutput(dataset.getFirstValueAt(), dataset.getOriginTimezone(), parameters), parameters, arg_0 -> ((DatasetOutput)result).setSamplingTimeStart(arg_0));
        result.setValue("samplingTimeEnd", (Object)this.createTimeOutput(dataset.getLastValueAt(), dataset.getOriginTimezone(), parameters), parameters, arg_0 -> ((DatasetOutput)result).setSamplingTimeEnd(arg_0));
        result.setValue("feature", (Object)this.getCondensedFeature(dataset.getFeature(), query), parameters, arg_0 -> ((DatasetOutput)result).setFeature(arg_0));
        return result;
    }

    private String createHref(String hrefBase, DatasetEntity dataset) {
        return HrefHelper.constructHref((String)hrefBase, (String)this.getCollectionName(dataset)) + "/" + dataset.getId();
    }

    private String getCollectionName(DatasetEntity dataset) {
        switch (dataset.getDatasetType()) {
            case individualObservation: {
                return "individualObservations";
            }
            case trajectory: {
                return "trajectories";
            }
            case profile: {
                return "profiles";
            }
            case timeseries: {
                return "timeseries";
            }
        }
        return "datasets";
    }

    protected DatasetOutput<V> createExpanded(DatasetEntity dataset, DbQuery query, Session session) {
        IoParameters params = query.getParameters();
        DatasetOutput<V> result = this.createCondensed(dataset, query, session);
        DatasetParameters datasetParams = this.createDatasetParameters(dataset, query.withoutFieldsFilter(), session);
        datasetParams.setPlatform((ParameterOutput)this.getCondensedPlatform(dataset.getPlatform(), query));
        if (dataset.getService() == null) {
            dataset.setService(this.getServiceEntity());
        }
        DataRepository<DatasetEntity, ?, V, ?> dataRepository = this.getDataRepositoryFactory(dataset);
        V firstValue = dataRepository.getFirstValue(dataset, session, query);
        V lastValue = dataset.getFirstValueAt().equals(dataset.getLastValueAt()) ? firstValue : dataRepository.getLastValue(dataset, session, query);
        List<ReferenceValueOutput<V>> refValues = dataRepository.getReferenceValues(dataset, query, session);
        lastValue = this.isReferenceSeries(dataset) && this.isCongruentValues((AbstractValue<?>)firstValue, (AbstractValue<?>)lastValue) ? firstValue : lastValue;
        result.setValue("referenceValues", refValues, params, arg_0 -> result.setReferenceValues(arg_0));
        result.setValue("parameters", (Object)datasetParams, params, arg_0 -> result.setDatasetParameters(arg_0));
        result.setValue("firstValue", firstValue, params, arg_0 -> result.setFirstValue(arg_0));
        result.setValue("lastValue", lastValue, params, arg_0 -> result.setLastValue(arg_0));
        return result;
    }

    private DataRepository<DatasetEntity, ?, V, ?> getDataRepositoryFactory(DatasetEntity dataset) {
        return this.dataRepositoryFactory.create(dataset.getObservationType().name(), dataset.getValueType().name(), DatasetEntity.class);
    }

    private boolean isCongruentValues(AbstractValue<?> firstValue, AbstractValue<?> lastValue) {
        return firstValue.getTimestamp().equals((Object)lastValue.getTimestamp());
    }

    private boolean isReferenceSeries(DatasetEntity series) {
        return series.getProcedure().isReference();
    }

    private String createDatasetLabel(DatasetEntity dataset, String locale) {
        PhenomenonEntity phenomenon = dataset.getPhenomenon();
        ProcedureEntity procedure = dataset.getProcedure();
        OfferingEntity offering = dataset.getOffering();
        AbstractFeatureEntity feature = dataset.getFeature();
        String procedureLabel = procedure.getLabelFrom(locale);
        String phenomenonLabel = phenomenon.getLabelFrom(locale);
        String offeringLabel = offering.getLabelFrom(locale);
        String stationLabel = feature.getLabelFrom(locale);
        StringBuilder sb = new StringBuilder();
        return sb.append(phenomenonLabel).append(" ").append(procedureLabel).append(", ").append(stationLabel).append(", ").append(offeringLabel).toString();
    }

    public DataRepositoryTypeFactory getDataRepositoryTypeFactory() {
        return this.dataRepositoryFactory;
    }

    public void setDataRepositoryTypeFactory(DataRepositoryTypeFactory dataRepositoryTypeFactory) {
        this.dataRepositoryFactory = dataRepositoryTypeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DatasetTypesMetadata> getDatasetTypesMetadata(IoParameters parameters) {
        Session session = this.getSession();
        try {
            List<DatasetTypesMetadata> list = this.getDatasetDao(DatasetEntity.class, session).getDatasetTypesMetadata(parameters.getDatasets(), this.getDbQuery(parameters));
            return list;
        }
        finally {
            this.returnSession(session);
        }
    }
}

