/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.dao;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.joda.time.Interval;
import org.n52.io.IntervalWithTimeZone;
import org.n52.io.request.IoParameters;
import org.n52.series.db.DataAccessException;
import org.n52.series.db.DataModelUtil;
import org.n52.series.db.beans.i18n.I18nSamplingEntity;
import org.n52.series.db.beans.sampling.SamplingEntity;
import org.n52.series.db.dao.AbstractDao;
import org.n52.series.db.dao.DbQuery;
import org.n52.series.db.dao.SearchableDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingDao
extends AbstractDao<SamplingEntity>
implements SearchableDao<SamplingEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamplingDao.class);

    public SamplingDao(Session session) {
        super(session);
    }

    @Override
    public List<SamplingEntity> find(DbQuery query) {
        if (!DataModelUtil.isEntitySupported(this.getEntityClass(), this.session)) {
            return Collections.emptyList();
        }
        LOGGER.debug("find instance: {}", (Object)query);
        Criteria criteria = this.getDefaultCriteria(query);
        criteria = this.i18n(this.getI18NEntityClass(), criteria, query);
        criteria.add(Restrictions.ilike((String)"name", (Object)("%" + query.getSearchTerm() + "%")));
        return this.addFilters(criteria, query).list();
    }

    @Override
    public List<SamplingEntity> getAllInstances(DbQuery query) throws DataAccessException {
        if (!DataModelUtil.isEntitySupported(this.getEntityClass(), this.session)) {
            return Collections.emptyList();
        }
        LOGGER.debug("get all instances: {}", (Object)query);
        Criteria criteria = this.getDefaultCriteria(query);
        criteria = this.i18n(this.getI18NEntityClass(), criteria, query);
        return this.addFilters(criteria, query).list();
    }

    private Criteria addFilters(Criteria criteria, DbQuery query) {
        this.addMonitoringProgramFilter(query, criteria);
        this.addTimespanTo(criteria, query.getParameters());
        Criteria datasetCriteria = criteria.createCriteria("datasets");
        if (query.getParameters().getSpatialFilter() != null) {
            this.addSpatialFilter(query, datasetCriteria);
        }
        return query.addFilters(datasetCriteria, this.getDatasetProperty());
    }

    private void addMonitoringProgramFilter(DbQuery query, Criteria criteria) {
        if (query.getParameters().containsParameter("measuringPrograms")) {
            criteria.createCriteria("measuringProgram").add(query.createIdFilter(query.getParameters().getMeasuringPrograms(), null));
        }
    }

    public Criteria addTimespanTo(Criteria criteria, IoParameters parameters) {
        if (parameters.containsParameter("timespan")) {
            IntervalWithTimeZone timespan = parameters.getTimespan();
            Interval interval = timespan.toInterval();
            Date start = interval.getStart().toDate();
            Date end = interval.getEnd().toDate();
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.between((String)"samplingTimeStart", (Object)start, (Object)end), Restrictions.between((String)"samplingTimeEnd", (Object)start, (Object)end), Restrictions.and((Criterion)Restrictions.le((String)"samplingTimeStart", (Object)start), (Criterion)Restrictions.ge((String)"samplingTimeEnd", (Object)end))}));
        }
        return criteria;
    }

    @Override
    protected SamplingEntity getInstance(String key, DbQuery query, Class<SamplingEntity> clazz) {
        if (!DataModelUtil.isEntitySupported(this.getEntityClass(), this.session)) {
            return null;
        }
        LOGGER.debug("get instance for '{}'. {}", (Object)key, (Object)query);
        Criteria criteria = this.session.createCriteria(clazz);
        return this.getInstance(key, query, clazz, criteria);
    }

    @Override
    protected Criteria getDefaultCriteria(String alias, DbQuery query, Class<?> clazz) {
        Criteria criteria = this.session.createCriteria(clazz);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria;
    }

    protected Class<I18nSamplingEntity> getI18NEntityClass() {
        return I18nSamplingEntity.class;
    }

    @Override
    protected Class<SamplingEntity> getEntityClass() {
        return SamplingEntity.class;
    }

    @Override
    protected String getDatasetProperty() {
        return "";
    }
}

