/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.da;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.da.SessionAwareRepository;

public class SessionAwareRepositoryTest {
    private String getPlatformId(Long id, boolean mobile, boolean insitu) {
        ProcedureEntity procedure = new ProcedureEntity();
        procedure.setId(id);
        FeatureEntity feature = new FeatureEntity();
        feature.setId(id);
        DatasetEntity dataset = new DatasetEntity();
        dataset.setMobile(mobile);
        dataset.setInsitu(insitu);
        dataset.setProcedure(procedure);
        dataset.setFeature((AbstractFeatureEntity)feature);
        SessionAwareRepository repo = new SessionAwareRepository(){};
        return Long.toString(id);
    }

    @Test
    public void getOriginTimeZone() {
        SessionAwareRepository testRepo = new SessionAwareRepository(){};
        Assert.assertTrue((testRepo.getOriginTimeZone("CET").getOffset(DateTime.now().getMillis()) == (testRepo.getOriginTimeZone("CET").toTimeZone().inDaylightTime(DateTime.now().toDate()) ? this.getOffsetFor(2) : this.getOffsetFor(1)) ? 1 : 0) != 0);
        Assert.assertTrue((testRepo.getOriginTimeZone("Europe/Berlin").getOffset(DateTime.now().getMillis()) == (testRepo.getOriginTimeZone("CET").toTimeZone().inDaylightTime(DateTime.now().toDate()) ? this.getOffsetFor(2) : this.getOffsetFor(1)) ? 1 : 0) != 0);
        Assert.assertTrue((testRepo.getOriginTimeZone("+05:00").getOffset(DateTime.now().getMillis()) == this.getOffsetFor(5) ? 1 : 0) != 0);
        Assert.assertTrue((testRepo.getOriginTimeZone("-05:00").getOffset(DateTime.now().getMillis()) == this.getOffsetFor(-5) ? 1 : 0) != 0);
    }

    private int getOffsetFor(int hours) {
        return 3600000 * hours;
    }
}

